/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.jobs.GridJobID;
import eu.geclipse.core.jobs.Messages;
import eu.geclipse.core.jobs.internal.Activator;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.ICreatorSourceMatcher;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.impl.AbstractGridJobCreator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.workflow.IGridWorkflowDescription;
import eu.geclipse.workflow.IGridWorkflowJobDescription;
import eu.geclipse.workflow.IGridWorkflowJobID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GridJobCreator
extends AbstractGridJobCreator
implements ICreatorSourceMatcher {
    public IGridElement create(IGridContainer parent) throws ProblemException {
        IResource resource = (IResource)this.getSource();
        if (resource == null) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Source object is null.", "eu.geclipse.core.jobs");
        }
        if (!(resource instanceof IFolder)) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "eu.geclipse.core.jobs");
        }
        return new GridJob((IFolder)resource);
    }

    protected boolean internalCanCreate(IGridJobDescription description) {
        return true;
    }

    public boolean canCreate(Object source) {
        return source instanceof IFolder ? GridJob.canCreate((IFolder)source) : false;
    }

    public IGridJob create(IGridContainer parent, IGridJobID id, IGridJobService jobService, String jobName) throws ProblemException {
        if (!(id instanceof GridJobID)) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", Messages.getString("GridJobCreator.cannotCreateJobFromID"), "eu.geclipse.core.jobs");
        }
        IContainer container = (IContainer)parent.getResource();
        IGridJobDescription description = this.getDescription();
        String uniqueJobName = this.findJobFileName(jobName, container);
        IFolder jobFolder = this.getJobFolder(container, uniqueJobName);
        try {
            jobFolder.delete(true, null);
            jobFolder.create(true, true, null);
            GridJob job = GridJob.createJobStructure(jobFolder, (GridJobID)id, jobService, description, uniqueJobName);
            if (description instanceof IGridWorkflowDescription && id instanceof IGridWorkflowJobID) {
                this.createWorkflowJobStructure(job, jobFolder, (IGridWorkflowJobID)id, jobService, (IGridWorkflowDescription)description);
            }
            this.setSource(jobFolder);
            parent.create((IGridElementCreator)this);
            IGridElement jobElement = GridModel.getRoot().findElement((IResource)jobFolder);
            IGridJob result = null;
            if (jobElement instanceof IGridJob) {
                result = (IGridJob)jobElement;
            }
            return result;
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.valueOf(Messages.getString("GridJobCreator.problemCreatingFolder")) + jobFolder.getName(), (Throwable)cExc, "eu.geclipse.core.jobs");
        }
    }

    private String findJobFileName(String jobName, IContainer container) {
        String baseJobName;
        String uniqueJobName = baseJobName = jobName != null ? jobName : Messages.getString("GridJobCreator.defaultJobName");
        int jobNr = 0;
        IFolder jobFolder = this.getJobFolder(container, uniqueJobName);
        while (jobFolder.exists()) {
            uniqueJobName = String.format("%s[%d]", baseJobName, ++jobNr);
            jobFolder = this.getJobFolder(container, uniqueJobName);
        }
        return uniqueJobName;
    }

    private IFolder getJobFolder(IContainer container, String uniqueJobName) {
        String folderName = String.format(".%s%s", uniqueJobName, GridJob.JOBFILE_EXTENSION);
        return container.getFolder((IPath)new Path(folderName));
    }

    private void createWorkflowJobStructure(GridJob workflowJob, IFolder jobFolder, IGridWorkflowJobID id, IGridJobService jobService, IGridWorkflowDescription workflowDescription) throws ProblemException {
        List childrenIds = id.getChildrenJobs();
        if (childrenIds != null) {
            for (IGridWorkflowJobID childId : childrenIds) {
                IGridWorkflowJobDescription childJob = this.findJob(workflowDescription, childId.getName());
                if (childJob == null) continue;
                JSDLJobDescription childJobDescription = this.createChildJobDescription(jobFolder, childJob);
                if (this.canCreate((IGridJobDescription)childJobDescription)) {
                    this.create((IGridContainer)workflowJob, (IGridJobID)childId, jobService, childJobDescription.getPath().removeFileExtension().lastSegment());
                }
                this.deleteTmpJobDescription(childJobDescription);
            }
        }
    }

    private void deleteTmpJobDescription(JSDLJobDescription childJobDescription) {
        IResource resource = childJobDescription.getResource();
        try {
            resource.delete(true, null);
        }
        catch (CoreException coreException) {}
    }

    private IGridWorkflowJobDescription findJob(IGridWorkflowDescription workflowDescription, String jobName) {
        IGridWorkflowJobDescription job = null;
        for (IGridWorkflowJobDescription curJob : workflowDescription.getChildrenJobs()) {
            if (!curJob.getName().equals(jobName)) continue;
            job = curJob;
            break;
        }
        return job;
    }

    private JSDLJobDescription createChildJobDescription(IFolder jobFolder, IGridWorkflowJobDescription childJob) throws ProblemException {
        JSDLJobDescription description;
        block14: {
            description = null;
            FileInputStream inputStream = null;
            Path descriptionPath = childJob.getDescriptionPath();
            String tmpJsdlFileName = String.format("%s.jsdl", childJob.getName());
            IFile outputFile = jobFolder.getFile(tmpJsdlFileName);
            try {
                inputStream = new FileInputStream(new File(descriptionPath.toString()));
                outputFile.create((InputStream)inputStream, true, null);
                description = new JSDLJobDescription(outputFile);
            }
            catch (CoreException exception) {
                Activator.logException(exception, "Cannot create jsdl job description for child job.");
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                break block14;
            }
            catch (FileNotFoundException exception) {
                try {
                    String msg = String.format("Job description file cannot be found %s", descriptionPath.toString());
                    throw new ProblemException("eu.geclipse.core.problem.io.operationFailed", msg, (Throwable)exception, "eu.geclipse.core.jobs");
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            if (inputStream == null) break block14;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return description;
    }
}

