/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.reporting.ProblemException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GridJobID
implements IGridJobID {
    static final String UNKNOWN = "Unknown";
    static final String XML_ROOT = "JobID";
    static final String XML_ATTRIBUTE_CLASS = "class";
    private static final String XML_NAMENODE = "Name";
    private static final String XML_DATANODE = "Data";
    private static final String XML_VONODE = "VO";
    private static final String XML_DATA_NODE_ROOT = "GriaJobId";
    private String jobID = "Unknown";
    private String VO = "Unknown";
    private GridJob job;

    public GridJobID() {
    }

    public GridJobID(String _jobID, String _VO) {
        this.jobID = _jobID;
        this.VO = _VO;
    }

    public GridJobID(Node jobIDNode) {
        this();
        this.setXMLNode(jobIDNode);
    }

    final void setXMLNode(Node statusNode) {
        NodeList childNodes = statusNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (XML_NAMENODE.equals(node.getNodeName())) {
                this.jobID = node.getTextContent();
                if (this.jobID != null) {
                    this.jobID = this.jobID.trim();
                }
            }
            if (XML_VONODE.equals(node.getNodeName())) {
                this.VO = node.getTextContent();
                if (this.VO != null) {
                    this.VO = this.VO.trim();
                }
            }
            if (XML_DATANODE.equals(node.getNodeName())) {
                this.setData(node.getTextContent());
            }
            ++i;
        }
    }

    public String getJobID() {
        return this.jobID;
    }

    protected void setData(String data) {
    }

    final String getXML() {
        return "<JobID class=\"" + this.getClass().getName() + "\"><Name>" + this.jobID + "</Name><VO>" + this.VO + "</VO><Data><![CDATA[" + this.getData() + "]]></Data></" + XML_ROOT + ">";
    }

    protected String getData() {
        return "";
    }

    public void setJob(GridJob job) {
        this.job = job;
    }

    public GridJob getJob() {
        return this.job;
    }

    public String getVO() {
        return this.VO;
    }

    protected String xmlGetNodeValue(Element parent, String nodeName) {
        String value = null;
        NodeList elements = parent.getElementsByTagName(nodeName);
        if (elements != null && elements.getLength() > 0) {
            value = elements.item(0).getTextContent();
        }
        return value;
    }

    protected String xmlToString(Document document) throws ProblemException {
        try {
            document.normalizeDocument();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            return outputStream.toString();
        }
        catch (TransformerConfigurationException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.xml2StringFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
        catch (TransformerFactoryConfigurationError exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.xml2StringFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
        catch (TransformerException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.xml2StringFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
    }

    protected Document xmlCreateDocument() throws ProblemException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement(XML_DATA_NODE_ROOT);
            document.appendChild(root);
            return document;
        }
        catch (ParserConfigurationException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.xmlCreateFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
    }

    protected Document xmlGetDocument(String data) throws ProblemException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
            Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            return xmlDocument;
        }
        catch (SAXException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.string2XmlFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
        catch (IOException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.string2XmlFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
        catch (ParserConfigurationException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.string2XmlFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
    }

    protected void xmlAddNode(Element parent, String nodeName, String value) {
        Element element = parent.getOwnerDocument().createElement(nodeName);
        parent.appendChild(element);
        element.appendChild(element.getOwnerDocument().createTextNode(value != null ? value : ""));
    }
}

