/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.jobs.Messages;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.reporting.ProblemException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GridJobStatus
implements IGridJobStatus {
    public static final String XML_ROOT = Messages.getString("GridJobStatus.jobStatus");
    public static final String XML_STATUSNAME = Messages.getString("GridJobStatus.name");
    public static final String XML_STATUSTYPE = Messages.getString("GridJobStatus.type");
    public static final String XML_STATUSREASON = Messages.getString("GridJobStatus.reason");
    public static final String XML_STATUSDATA = Messages.getString("GridJobStatus.data");
    public static final String XML_STATUSUPDATEDATE = Messages.getString("GridJobStatus.updateDate");
    public static final String XML_ATTRIBUTE_CLASS = "class";
    public static final GridJobStatus UNKNOWN_STATUS = new GridJobStatus();
    protected int type;
    protected String name = null;
    protected String reason = null;
    protected Date updateDate = null;
    private String data = null;

    public GridJobStatus() {
        this(Messages.getString("GridJobStatus.unknown"), 128);
    }

    public GridJobStatus(String name, int type) {
        this.name = name;
        this.type = type;
        this.reason = "";
        this.data = null;
        this.updateDate = Calendar.getInstance().getTime();
    }

    public GridJobStatus(Node statusNode) throws ProblemException {
        this();
        this.setXMLNode(statusNode);
    }

    public void setXMLNode(Node statusNode) throws ProblemException {
        NodeList childNodes = statusNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (XML_STATUSNAME.equals(node.getNodeName())) {
                this.name = node.getTextContent();
                if (this.name != null) {
                    this.name = this.name.trim();
                }
            }
            if (XML_STATUSREASON.equals(node.getNodeName())) {
                this.reason = node.getTextContent();
                if (this.reason != null) {
                    this.reason = this.reason.trim();
                }
            }
            if (XML_STATUSUPDATEDATE.equals(node.getNodeName())) {
                try {
                    this.updateDate = this.getXmlDateFormatter().parse(node.getTextContent());
                }
                catch (DOMException dOMException) {
                }
                catch (ParseException parseException) {}
            }
            if (XML_STATUSTYPE.equals(node.getNodeName())) {
                try {
                    this.type = Integer.parseInt(node.getTextContent());
                }
                catch (Exception exception) {
                    this.type = 0;
                }
            }
            if (XML_STATUSDATA.equals(node.getNodeName())) {
                this.setData(node.getTextContent());
            }
            ++i;
        }
    }

    public boolean canChange() {
        boolean canChange = true;
        switch (this.type) {
            case 8: 
            case 16: 
            case 32: {
                canChange = false;
            }
        }
        return canChange;
    }

    public boolean isSuccessful() {
        return this.type == 8;
    }

    public String getJobStatusData() {
        return this.data;
    }

    public final String getXML() {
        String xml = "";
        xml = String.valueOf(xml) + "<" + XML_ROOT + " " + XML_ATTRIBUTE_CLASS + "=\"" + this.getClass().getName() + "\">";
        xml = String.valueOf(xml) + "  <" + XML_STATUSNAME + ">" + this.name + "</" + XML_STATUSNAME + ">\n";
        xml = String.valueOf(xml) + "  <" + XML_STATUSTYPE + ">" + this.type + "</" + XML_STATUSTYPE + ">\n";
        if (this.updateDate != null) {
            xml = String.valueOf(xml) + "  <" + XML_STATUSUPDATEDATE + ">" + this.getXmlDateFormatter().format(this.updateDate) + "</" + XML_STATUSUPDATEDATE + ">\n";
        }
        if (this.reason != null) {
            xml = String.valueOf(xml) + "  <" + XML_STATUSREASON + ">" + this.reason.replaceAll("&", "") + "</" + XML_STATUSREASON + ">\n";
        }
        xml = String.valueOf(xml) + "<" + XML_STATUSDATA + "><![CDATA[" + this.getData() + "]]></" + XML_STATUSDATA + ">";
        xml = String.valueOf(xml) + "</" + XML_ROOT + ">\n";
        return xml;
    }

    private DateFormat getXmlDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, new Locale("Locale.US"));
        if (formatter == null) {
            formatter = DateFormat.getDateTimeInstance(2, 2);
        }
        return formatter;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public Date getLastUpdateTime() {
        return this.updateDate;
    }

    protected String getData() {
        return null;
    }

    protected void setData(String data) throws ProblemException {
    }
}

