/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.jobs.GridJobCreator;
import eu.geclipse.core.jobs.Messages;
import eu.geclipse.core.jobs.internal.ParametricJobID;
import eu.geclipse.core.jobs.internal.ParametricJobStatus;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.parametric.IParametricJsdlGenerator;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricGenerationCanceled;
import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.ParametricJsdlGeneratorFactory;
import eu.geclipse.jsdl.parametric.eclipse.ParametricJsdlSaver;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricJobService
implements IGridJobService {
    private IGridJobService jobService;
    private GridJob job;

    public ParametricJobService(IGridJobService jobService) {
        this.jobService = jobService;
    }

    public ParametricJobService(ParametricJobID jobID) {
        this.job = jobID.getJob();
    }

    public boolean canSubmit(IGridJobDescription desc) {
        return this.jobService != null && this.jobService.canSubmit(desc);
    }

    public void deleteJob(IGridJobID dummyJobId, IVirtualOrganization vo, IProgressMonitor monitor) throws ProblemException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        List<GridJob> childrenJobs = this.getChildrenJobs();
        subMonitor.setWorkRemaining(childrenJobs.size());
        for (GridJob gridJob : childrenJobs) {
            gridJob.deleteJob((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public IGridJobStatus getJobStatus(IGridJobID id, IVirtualOrganization vo, boolean fullStatus, IProgressMonitor progressMonitor) throws ProblemException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        HashSet<String> statusNames = new HashSet<String>();
        int statusType = 8;
        List<GridJob> childrenJobs = this.getChildrenJobs();
        subMonitor.setWorkRemaining(childrenJobs.size());
        boolean unkOccured = false;
        boolean abortedOccured = false;
        boolean runningOccured = false;
        boolean waitingOccured = false;
        boolean submittedOccured = false;
        for (GridJob gridJob : childrenJobs) {
            subMonitor.subTask(String.format(Messages.getString("ParametricJobService.taskNameUpdating"), gridJob.getJobName()));
            IGridJobStatus oldStatus = gridJob.getJobStatus();
            IGridJobStatus jobStatus = gridJob.updateJobStatus((IProgressMonitor)subMonitor.newChild(1), fullStatus);
            statusNames.add(jobStatus.getName());
            GridModel.getJobManager().jobStatusChanged((IGridJob)gridJob, oldStatus);
            switch (jobStatus.getType()) {
                case 8: {
                    break;
                }
                case 1: {
                    submittedOccured = true;
                    break;
                }
                case 16: {
                    abortedOccured = true;
                    break;
                }
                case 2: {
                    waitingOccured = true;
                    break;
                }
                case 4: {
                    runningOccured = true;
                    break;
                }
                case 32: 
                case 64: 
                case 128: {
                    unkOccured = true;
                }
            }
        }
        statusType = unkOccured ? 128 : (abortedOccured ? 16 : (submittedOccured ? 1 : (waitingOccured ? 2 : (runningOccured ? 4 : 8))));
        return new ParametricJobStatus(((Object)statusNames).toString(), statusType, childrenJobs);
    }

    private List<GridJob> getChildrenJobs() throws ProblemException {
        IGridElement[] children = this.job.getChildren((IProgressMonitor)new NullProgressMonitor());
        ArrayList<GridJob> childrenJobs = new ArrayList<GridJob>(children.length);
        IGridElement[] iGridElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement gridElement = iGridElementArray[n2];
            if (gridElement instanceof GridJob) {
                childrenJobs.add((GridJob)gridElement);
            }
            ++n2;
        }
        return childrenJobs;
    }

    public IGridJob createParamJobStructure(JSDLJobDescription jsdl, IGridContainer parent, String jobName) throws ProblemException {
        ParametricJobID jobId = new ParametricJobID();
        GridJobCreator creator = new GridJobCreator();
        creator.canCreate((IGridJobDescription)jsdl);
        return creator.create(parent, jobId, this, jobName);
    }

    public IGridJobID submitJob(IGridJobDescription description, SubMonitor monitor, IGridContainer parent, String jobName) throws ProblemException {
        IGridJobID jobId = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Assert.isTrue((boolean)(description instanceof JSDLJobDescription));
        JSDLJobDescription jsdl = (JSDLJobDescription)description;
        if (this.isResumedSubmition(jsdl)) {
            jobId = this.resumeSubmission(jsdl, subMonitor);
        } else {
            Assert.isTrue((boolean)jsdl.isParametric());
            subMonitor.setWorkRemaining(10);
            subMonitor.subTask(Messages.getString("ParametricJobService.taskNameGeneratingJsdl"));
            IGridJob parametricGridJob = this.createParamJobStructure(jsdl, parent, jobName);
            IParametricJsdlGenerator generator = ParametricJsdlGeneratorFactory.getGenerator((String)jsdl.getAsString());
            IFolder generationTargetfolder = ((IFolder)parametricGridJob.getResource()).getFolder(Messages.getString("ParametricJobService.generatedJsdlFolder"));
            ParametricJsdlSaver saver = new ParametricJsdlSaver(jsdl, generationTargetfolder, subMonitor.newChild(1));
            try {
                generator.generate((IParametricJsdlHandler)saver);
            }
            catch (ParametricGenerationCanceled parametricGenerationCanceled) {
                throw new OperationCanceledException();
            }
            catch (ParametricJsdlException exception) {
                throw new ProblemException("eu.geclipse.core.jobs.problem.generateParamJsdlFailed", (Throwable)exception, "eu.geclipse.core.jobs");
            }
            List generatedJsdls = saver.getGeneratedJsdl();
            this.submitGeneratedJsdl(parametricGridJob, generatedJsdls, subMonitor.newChild(9), jobName);
            this.cleanupSubmission(generationTargetfolder);
            jobId = new ParametricJobID();
        }
        return jobId;
    }

    private IGridJobID resumeSubmission(JSDLJobDescription jsdl, SubMonitor monitor) throws ProblemException {
        GridJob parentJob = this.findParentParamJob(jsdl);
        Assert.isNotNull((Object)((Object)parentJob));
        ArrayList<JSDLJobDescription> jsdlList = new ArrayList<JSDLJobDescription>(1);
        jsdlList.add(jsdl);
        this.submitGeneratedJsdl(parentJob, jsdlList, monitor, parentJob.getJobName());
        this.cleanupSubmission((IFolder)jsdl.getResource().getParent());
        return parentJob.getID();
    }

    private boolean isResumedSubmition(JSDLJobDescription jsdl) {
        return this.findParentParamJob(jsdl) != null;
    }

    private GridJob findParentParamJob(JSDLJobDescription jsdl) {
        GridJob paramJob = null;
        if (!jsdl.isParametric()) {
            IGridContainer parent = jsdl.getParent();
            while (parent != null) {
                if (parent instanceof GridJob) {
                    GridJob parentJob = (GridJob)parent;
                    IGridJobDescription parentDescription = parentJob.getJobDescription();
                    if (!(parentDescription instanceof JSDLJobDescription) || !((JSDLJobDescription)parentDescription).isParametric()) break;
                    paramJob = parentJob;
                    break;
                }
                parent = parent.getParent();
            }
        }
        return paramJob;
    }

    private void cleanupSubmission(IFolder generationTargetfolder) throws ProblemException {
        try {
            if (generationTargetfolder.members().length == 0) {
                generationTargetfolder.delete(true, null);
            }
        }
        catch (CoreException exception) {
            throw new ProblemException("eu.geclipse.core.jobs.problem.cleanupSubmissionFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
    }

    private List<IGridJobID> submitGeneratedJsdl(IGridJob parametricJob, List<JSDLJobDescription> generatedJsdls, SubMonitor monitor, String jobName) throws ProblemException {
        ArrayList<IGridJobID> submittedJobs = new ArrayList<IGridJobID>(generatedJsdls.size());
        GridJobCreator jobCreator = new GridJobCreator();
        monitor.setWorkRemaining(generatedJsdls.size());
        for (JSDLJobDescription jobDescription : generatedJsdls) {
            String subjobName = this.getSubJobName(jobDescription, jobName);
            this.testCancelled(monitor);
            monitor.setTaskName(String.format(Messages.getString("ParametricJobService.taskSubmitting"), jobDescription.getName()));
            IGridJobID jobID = this.jobService.submitJob((IGridJobDescription)jobDescription, (IProgressMonitor)monitor.newChild(1));
            submittedJobs.add(jobID);
            this.testCancelled(monitor);
            jobCreator.canCreate((IGridJobDescription)jobDescription);
            jobCreator.create((IGridContainer)parametricJob, jobID, this.jobService, subjobName);
            try {
                jobDescription.getResource().delete(true, (IProgressMonitor)monitor.newChild(0));
            }
            catch (CoreException exception) {
                throw new ProblemException("eu.geclipse.core.jobs.problem.deleteGeneratedJsdlFailed", (Throwable)exception, "eu.geclipse.core.jobs");
            }
        }
        return submittedJobs;
    }

    private String getSubJobName(JSDLJobDescription jobDescription, String jobName) {
        String subJobName = jobName;
        String jsdlName = new Path(jobDescription.getName()).removeFileExtension().toString();
        int suffixIndex = jsdlName.indexOf(91);
        if (suffixIndex > -1) {
            subJobName = String.valueOf(jobName) + jsdlName.substring(suffixIndex);
        }
        return subJobName;
    }

    private void testCancelled(SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public String getHostName() {
        return this.jobService != null ? this.jobService.getHostName() : Messages.getString("ParametricJobService.unknownHostName");
    }

    public URI getURI() {
        return this.jobService != null ? this.jobService.getURI() : null;
    }

    public void dispose() {
        if (this.jobService != null) {
            this.jobService.dispose();
        }
    }

    public IFileStore getFileStore() {
        return this.jobService.getFileStore();
    }

    public String getName() {
        return this.jobService.getName();
    }

    public IGridContainer getParent() {
        return this.jobService.getParent();
    }

    public IPath getPath() {
        return this.jobService.getPath();
    }

    public IGridProject getProject() {
        return this.jobService != null ? this.jobService.getProject() : null;
    }

    public IResource getResource() {
        return this.jobService.getResource();
    }

    public boolean isHidden() {
        return this.jobService.isHidden();
    }

    public boolean isLocal() {
        return this.jobService.isLocal();
    }

    public boolean isVirtual() {
        return this.jobService.isVirtual();
    }

    public Object getAdapter(Class adapter) {
        return this.jobService != null ? this.jobService.getAdapter(adapter) : null;
    }

    public IGridJobID submitJob(IGridJobDescription description, IProgressMonitor monitor) throws ProblemException {
        String msg = "ParametricJobService can submit only parametric JSDLs";
        throw new ProblemException("eu.geclipse.core.jobs.problem.unsupportedOperation", msg, "eu.geclipse.core.jobs");
    }

    public IGridJobID submitJob(IGridJobDescription description, IVirtualOrganization vo, IProgressMonitor monitor) throws ProblemException {
        String msg = "ParametricJobService can submit only parametric JSDLs";
        throw new ProblemException("eu.geclipse.core.jobs.problem.unsupportedOperation", msg, "eu.geclipse.core.jobs");
    }

    public Map<String, URI> getInputFiles(IGridJobID jobId, IGridJobDescription jobDescription, IVirtualOrganization vo) throws ProblemException {
        return null;
    }

    public Map<String, URI> getOutputFiles(IGridJobID jobId, IGridJobDescription jobDescription, IVirtualOrganization vo) throws ProblemException {
        return null;
    }
}

