/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import eu.geclipse.core.jobs.internal.Activator;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class RemoteFilesContainer
extends ResourceGridContainer {
    boolean constructed = true;

    public RemoteFilesContainer(IResource resource) {
        super(resource);
    }

    public boolean isLazy() {
        return true;
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IStatus status = super.fetchChildren(monitor);
        if (this.constructed) {
            this.fetchChildrenInfo(subMonitor);
        }
        return status;
    }

    protected void fetchChildrenInfo(SubMonitor monitor) {
        try {
            List currentChildren = this.getCachedChildren();
            monitor.setWorkRemaining(currentChildren.size());
            for (IGridElement gridElement : currentChildren) {
                if (!(gridElement instanceof IGridConnectionElement)) continue;
                IGridConnectionElement connectionElement = (IGridConnectionElement)gridElement;
                IFileStore fileStore = connectionElement.getConnectionFileStore();
                if (fileStore instanceof GEclipseFileStore) {
                    GEclipseFileStore geclFileStore = (GEclipseFileStore)fileStore;
                    geclFileStore.setActive(2);
                    geclFileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                    continue;
                }
                monitor.worked(1);
            }
        }
        catch (ProblemException exception) {
            Activator.logException(exception);
        }
        catch (CoreException exception) {
            Activator.logException(exception);
        }
    }

    public boolean canContain(IGridElement element) {
        return element instanceof IGridConnectionElement;
    }
}

