/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.reporting.internal;

import eu.geclipse.core.reporting.internal.Problem;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ProblemFactory {
    private static ProblemFactory singleton;
    private IExtensionPoint problemReporting;

    private ProblemFactory() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.problemReporting = registry.getExtensionPoint("eu.geclipse.core.reporting.problemReporting");
    }

    public static ProblemFactory getFactory() {
        if (singleton == null) {
            singleton = new ProblemFactory();
        }
        return singleton;
    }

    public Problem getProblem(String problemID, String description, Throwable exception, String pluginID) {
        Problem result = null;
        IConfigurationElement element = this.getProblemElement(problemID);
        if (element == null) {
            element = this.getProblemElement("eu.geclipse.core.reporting.problem.unknown");
        }
        result = element != null ? this.createProblem(element, description, exception, pluginID) : new Problem("eu.geclipse.core.reporting.problem.unknown", description, exception, null, pluginID);
        return result;
    }

    private Problem createProblem(IConfigurationElement element, String description, Throwable exception, String pluginID) {
        String id = element.getAttribute("id");
        String mailto = element.getAttribute("mailto");
        String desc = description;
        if (desc == null) {
            desc = element.getAttribute("description");
        }
        Problem problem = new Problem(id, desc, exception, mailto, pluginID);
        this.addInternalSolutions(problem, element);
        this.addExternalSolutions(problem);
        return problem;
    }

    private IConfigurationElement getProblemElement(String problemID) {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = this.problemReporting.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                String id;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String name = element.getName();
                if ("problem".equals(name) && problemID.equals(id = element.getAttribute("id"))) {
                    return element;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private void addExternalSolutions(Problem problem) {
        IExtension[] extensions = this.problemReporting.getExtensions();
        String id = problem.getID();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("solution".equals(element.getName())) {
                    IConfigurationElement[] children;
                    IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren();
                    int n5 = children.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String problemReference;
                        IConfigurationElement child = iConfigurationElementArray2[n6];
                        if ("reference".equals(child.getName()) && id.equals(problemReference = child.getAttribute("referenceID"))) {
                            String solutionID = element.getAttribute("id");
                            problem.addSolution(solutionID, null);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void addInternalSolutions(Problem problem, IConfigurationElement element) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if ("reference".equals(child.getName())) {
                String solutionID = child.getAttribute("referenceID");
                problem.addSolution(solutionID, null);
            }
            ++n2;
        }
    }
}

