/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.auth.AuthTokenRequest;
import eu.geclipse.core.auth.IAuthTokenProvider;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.reporting.ProblemException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractAuthTokenProvider
implements IAuthTokenProvider {
    public static boolean isTokenRequestCanceledException(Throwable t) {
        boolean result = false;
        if (t != null) {
            if (t instanceof ProblemException) {
                String id = ((ProblemException)t).getProblem().getID();
                result = "eu.geclipse.core.problem.auth.tokenRequestCanceled".equals(id);
            }
            if (!result && t.getCause() != null) {
                result = AbstractAuthTokenProvider.isTokenRequestCanceledException(t.getCause());
            }
        }
        return result;
    }

    public static synchronized IAuthenticationToken staticRequestToken() throws ProblemException {
        IAuthTokenProvider provider = AbstractAuthTokenProvider.getHighestPriorityProvider();
        return provider == null ? null : provider.requestToken();
    }

    public static synchronized IAuthenticationToken staticRequestToken(AuthTokenRequest request) throws ProblemException {
        IAuthTokenProvider provider = AbstractAuthTokenProvider.getHighestPriorityProvider();
        return provider == null ? null : provider.requestToken(request);
    }

    private static IAuthTokenProvider getHighestPriorityProvider() {
        ExtensionManager extensionBrowser = new ExtensionManager();
        List<IConfigurationElement> providers = extensionBrowser.getConfigurationElements("eu.geclipse.core.authTokenProvider", "provider");
        Hashtable<Integer, IConfigurationElement> providerMap = new Hashtable<Integer, IConfigurationElement>();
        for (IConfigurationElement element : providers) {
            String prioString = element.getAttribute("priority");
            try {
                Integer prio = Integer.valueOf(prioString);
                providerMap.put(prio, element);
            }
            catch (NumberFormatException nfExc) {
                Activator.logException(nfExc);
            }
        }
        IAuthTokenProvider provider = null;
        Object[] keys = providerMap.keySet().toArray(new Integer[providerMap.size()]);
        Arrays.sort(keys);
        int i = keys.length - 1;
        while (i >= 0 && provider == null) {
            IConfigurationElement element = (IConfigurationElement)providerMap.get(keys[i]);
            try {
                provider = (IAuthTokenProvider)element.createExecutableExtension("class");
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
            --i;
        }
        return provider;
    }
}

