/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.auth;

import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.util.SecureFile;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractAuthenticationToken
implements IAuthenticationToken {
    private IAuthenticationTokenDescription description;

    public AbstractAuthenticationToken(IAuthenticationTokenDescription description) {
        this.description = description;
    }

    public static IPath getTokenLocation() {
        SecureFile file;
        IPath location = Activator.getDefault().getStateLocation();
        if (!location.hasTrailingSeparator()) {
            location = location.addTrailingSeparator();
        }
        if (!(file = new SecureFile((location = location.append(".tokens")).toOSString())).exists()) {
            file.mkdir();
        } else {
            try {
                file.setSecure();
            }
            catch (IOException iOException) {}
        }
        return location;
    }

    public IAuthenticationTokenDescription getDescription() {
        return this.description;
    }

    public void setActive(boolean active) throws AuthenticationException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.setActive(active, (IProgressMonitor)monitor);
    }

    public void validate() throws AuthenticationException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.validate((IProgressMonitor)monitor);
    }

    protected void fireTokenStateChanged() {
        AuthenticationTokenManager.getManager().fireContentChanged();
    }

    public IPath getTokenFile() {
        IPath path = AbstractAuthenticationToken.getTokenLocation();
        path = path.addTrailingSeparator().append(this.getID());
        return path;
    }
}

