/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.config;

import eu.geclipse.core.config.Configuration;
import eu.geclipse.core.config.IConfiguration;
import eu.geclipse.core.config.IConfigurator;
import eu.geclipse.core.config.Messages;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IConfigurableElementCreator;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.project.GridProjectCreationOperation;
import eu.geclipse.core.project.GridProjectProperties;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.core.security.Security;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator
implements IConfigurator {
    private static final String VO_NAME_PARAMETER = "name";
    private Hashtable<ICertificateLoader, URI[]> certificateLoaders = new Hashtable();
    private Hashtable<IConfigurableElementCreator, Configuration> voCreators = new Hashtable();
    private List<ProjectConfiguration> projectConfigs = new ArrayList<ProjectConfiguration>();

    public void addCertificateLoader(ICertificateLoader loader, URI[] repositories) {
        this.certificateLoaders.put(loader, repositories);
    }

    public void addProjectConfiguration(String projectName, String voName, Hashtable<String, String> projectFolders) {
        this.projectConfigs.add(new ProjectConfiguration(projectName, voName, projectFolders));
    }

    public void addVoCreator(IConfigurableElementCreator creator, String voName, Configuration configuration) {
        configuration.setParameter(VO_NAME_PARAMETER, voName);
        this.voCreators.put(creator, configuration);
    }

    @Override
    public IStatus configure(IProgressMonitor monitor) throws ProblemException {
        MultiStatus result = new MultiStatus("eu.geclipse.core", 0, Messages.getString("Configurator.configuration_problem"), null);
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("Configurator.configuration_progress"), (int)3);
        try {
            IStatus certImportStatus = this.doCertificateImport(sMonitor.newChild(1));
            if (!certImportStatus.isOK()) {
                result.merge(certImportStatus);
            }
            this.testMonitor((IProgressMonitor)sMonitor);
            IStatus voSetupStatus = this.doVoSetup(sMonitor.newChild(1));
            if (!voSetupStatus.isOK()) {
                result.merge(voSetupStatus);
            }
            this.testMonitor((IProgressMonitor)sMonitor);
            IStatus projectSetupStatus = this.doProjectSetup(sMonitor.newChild(1));
            if (!projectSetupStatus.isOK()) {
                result.merge(projectSetupStatus);
            }
        }
        catch (Throwable t) {
            sMonitor.done();
            result.add((IStatus)new Status(4, "eu.geclipse.core", Messages.getString("Configurator.configuration_error"), t));
        }
        return result.getChildren() == null || result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    private IStatus doCertificateImport(SubMonitor monitor) {
        MultiStatus result = new MultiStatus("eu.geclipse.core", 0, Messages.getString("Configurator.cert_import_problem"), null);
        if (!this.certificateLoaders.isEmpty()) {
            Set<ICertificateLoader> keys = this.certificateLoaders.keySet();
            ICertificateManager certificateManager = Security.getCertificateManager();
            monitor.beginTask(Messages.getString("Configurator.cert_import_progress"), 2 * keys.size());
            for (ICertificateLoader loader : keys) {
                URI[] uris;
                URI[] uRIArray = uris = this.certificateLoaders.get(loader);
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    try {
                        ICertificateLoader.CertificateID[] certificateIDs = loader.listAvailableCertificates(uri, (IProgressMonitor)monitor.newChild(1));
                        this.testMonitor((IProgressMonitor)monitor);
                        SubMonitor sMonitor = monitor.newChild(1);
                        sMonitor.setWorkRemaining(certificateIDs.length);
                        ICertificateLoader.CertificateID[] certificateIDArray = certificateIDs;
                        int n3 = certificateIDs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICertificateLoader.CertificateID id = certificateIDArray[n4];
                            try {
                                X509Certificate certificate = loader.fetchCertificate(id, (IProgressMonitor)sMonitor.newChild(1));
                                if (certificate != null) {
                                    certificateManager.addCertificate(certificate, ICertificateManager.CertTrust.AlwaysTrusted);
                                }
                            }
                            catch (ProblemException pExc) {
                                result.merge(pExc.getStatus());
                            }
                            ++n4;
                        }
                        this.testMonitor((IProgressMonitor)monitor);
                    }
                    catch (ProblemException pExc) {
                        result.merge(pExc.getStatus());
                    }
                    ++n2;
                }
            }
        }
        monitor.done();
        return result.getChildren() == null || result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    private IStatus doProjectSetup(SubMonitor monitor) {
        MultiStatus result = new MultiStatus("eu.geclipse.core", 0, Messages.getString("Configurator.cert_import_problem"), null);
        if (this.projectConfigs != null) {
            monitor.beginTask(Messages.getString("Configurator.create_project_progress"), this.projectConfigs.size());
            IVoManager voManager = GridModel.getVoManager();
            for (ProjectConfiguration config : this.projectConfigs) {
                GridProjectProperties properties = new GridProjectProperties();
                properties.setProjectName(config.getProjectName());
                properties.setProjectVo((IVirtualOrganization)voManager.findChild(config.getVoName()));
                properties.addProjectFolders(config.getProjectFolders());
                try {
                    GridProjectCreationOperation op = new GridProjectCreationOperation(properties);
                    op.run((IProgressMonitor)monitor.newChild(1));
                }
                catch (ProblemException pExc) {
                    result.merge(pExc.getStatus());
                }
                this.testMonitor((IProgressMonitor)monitor);
            }
        }
        monitor.done();
        return result.getChildren() == null || result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    private IStatus doVoSetup(SubMonitor monitor) {
        MultiStatus result = new MultiStatus("eu.geclipse.core", 0, Messages.getString("Configurator.vo_setup_problem"), null);
        if (!this.voCreators.isEmpty()) {
            IVoManager voManager = GridModel.getVoManager();
            Set<IConfigurableElementCreator> keySet = this.voCreators.keySet();
            monitor.beginTask(Messages.getString("Configurator.vo_setup_progress"), keySet.size());
            for (IConfigurableElementCreator creator : keySet) {
                IConfiguration config = this.voCreators.get(creator);
                creator.setConfiguration(config);
                try {
                    voManager.create(creator);
                    monitor.worked(1);
                }
                catch (ProblemException pExc) {
                    result.merge(pExc.getStatus());
                }
                this.testMonitor((IProgressMonitor)monitor);
            }
        }
        monitor.done();
        return result.getChildren() == null || result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    private void testMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectConfiguration {
        private String projectName;
        private String voName;
        private Hashtable<String, String> projectFolders;

        public ProjectConfiguration(String projectName, String voName, Hashtable<String, String> projectFolders) {
            this.projectName = projectName;
            this.voName = voName;
            this.projectFolders = projectFolders;
        }

        public Hashtable<String, String> getProjectFolders() {
            return this.projectFolders;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getVoName() {
            return this.voName;
        }
    }
}

