/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal;

import eu.geclipse.core.security.Security;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "eu.geclipse.core";
    private static Activator plugin;
    private ServiceTracker tracker;

    public Activator() {
        plugin = this;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
        try {
            SSLSocketFactory socketFactory = Security.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        }
        catch (Exception exc) {
            Activator.logException(exc);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.tracker.close();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Throwable exc) {
        String message = exc.getLocalizedMessage();
        if (message == null) {
            message = exc.getClass().getName();
        }
        Status status = new Status(4, PLUGIN_ID, 0, message, exc);
        Activator.logStatus((IStatus)status);
    }

    public static void logStatus(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }
}

