/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractGridElementManager
extends AbstractGridElement
implements IGridElementManager {
    private Hashtable<IPath, IGridElement> elements = new Hashtable();
    private List<IGridModelListener> listeners = new ArrayList<IGridModelListener>();

    protected AbstractGridElementManager() {
    }

    public void addGridModelListener(IGridModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean canContain(IGridElement element) {
        return this.canManage(element);
    }

    public boolean contains(IGridElement element) {
        return this.elements.values().contains(element);
    }

    public IGridElement create(IGridElementCreator creator) throws ProblemException {
        IGridElement newElement = creator.create(this);
        if (newElement != null) {
            this.addElement(newElement);
        }
        return newElement;
    }

    public void delete(IGridElement child) {
        if (this.removeElement(child)) {
            child.dispose();
        }
    }

    public void deleteAll() {
        if (this.elements != null && !this.elements.isEmpty()) {
            Collection<IGridElement> values = this.elements.values();
            for (IGridElement element : values) {
                element.dispose();
            }
            IGridElement[] elementArray = values.toArray(new IGridElement[this.elements.size()]);
            this.fireGridModelEvent(2, elementArray);
            this.elements.clear();
        }
    }

    public IGridElement findChild(String name) {
        IGridElement result = null;
        for (IGridElement element : this.elements.values()) {
            if (!element.getName().equals(name)) continue;
            result = element;
            break;
        }
        return result;
    }

    public IGridElement findChild(IPath path) {
        return this.elements.get(path);
    }

    public IGridElement findChildWithResource(String resourceName) {
        IGridElement result = null;
        for (IGridElement element : this.elements.values()) {
            IResource resource = element.getResource();
            if (resource == null || !resource.getName().equals(resourceName)) continue;
            result = element;
            break;
        }
        return result;
    }

    public int getChildCount() {
        return this.elements.size();
    }

    public IGridElement[] getChildren(IProgressMonitor monitor) {
        Collection<IGridElement> values = this.elements.values();
        return values.toArray(new IGridElement[values.size()]);
    }

    public boolean hasChildren() {
        return !this.elements.isEmpty();
    }

    public boolean isDirty() {
        return false;
    }

    public IFileStore getFileStore() {
        IFileStore managerStore = AbstractGridElementManager.getManagerStore();
        IFileStore childStore = managerStore.getChild(this.getName());
        IFileInfo childInfo = childStore.fetchInfo();
        if (!childInfo.exists()) {
            try {
                childStore.mkdir(0, null);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return childStore;
    }

    public static IFileStore getManagerStore() {
        Activator activator = Activator.getDefault();
        IPath statePath = null;
        if (activator != null) {
            statePath = activator.getStateLocation();
        }
        return EFS.getLocalFileSystem().getStore(statePath);
    }

    public IGridContainer getParent() {
        return GridModel.getRoot();
    }

    public IPath getPath() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getFullPath();
        return rootPath.append(this.getName());
    }

    public IGridProject getProject() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void refresh(IProgressMonitor monitor) {
    }

    public void removeGridModelListener(IGridModelListener listener) {
        this.listeners.remove(listener);
    }

    public void setDirty() {
    }

    public boolean addElement(IGridElement element) throws ProblemException {
        boolean result = false;
        this.testCanManage(element);
        IPath path = element.getPath();
        IGridElement oldElement = this.findChild(path);
        if (element != oldElement) {
            if (oldElement != null) {
                this.delete(oldElement);
            }
            this.elements.put(path, element);
            GridModelEvent event = new GridModelEvent(1, this, new IGridElement[]{element});
            this.fireGridModelEvent(event);
            result = true;
        }
        return result;
    }

    public boolean removeElement(IGridElement element) {
        boolean removed;
        IPath path = element.getPath();
        boolean bl = removed = this.elements.remove(path) != null;
        if (removed) {
            GridModelEvent event = new GridModelEvent(2, this, new IGridElement[]{element});
            this.fireGridModelEvent(event);
        }
        return removed;
    }

    protected void fireGridModelEvent(int type, IGridElement[] elementArray) {
        if (elementArray != null && elementArray.length > 0) {
            GridModelEvent event = new GridModelEvent(type, this, elementArray);
            this.fireGridModelEvent(event);
        }
    }

    protected void fireGridModelEvent(IGridModelEvent event) {
        for (IGridModelListener listener : this.listeners) {
            listener.gridModelChanged(event);
        }
    }

    protected void testCanManage(IGridElement element) throws ProblemException {
        if (!this.canManage(element)) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementNotManageable", "eu.geclipse.core");
        }
    }
}

