/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.model.ICreatorSourceMatcher;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCreatorReference {
    private IConfigurationElement configurationElement;
    private IGridElementCreator elementCreator;
    private List<SourceMatcher> sourceMatchers;
    private TargetMatcher targetMatcher;

    ElementCreatorReference(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    public int checkSource(Object source) throws ProblemException {
        int result = 0;
        if (source != null) {
            result = -1;
            if (this.sourceMatchers == null) {
                this.initSourceMatchers();
            }
            for (SourceMatcher matcher : this.sourceMatchers) {
                int priority;
                if (!matcher.matches(source) || (priority = matcher.getPriority()) <= result) continue;
                result = priority;
            }
        }
        return result;
    }

    public boolean checkTarget(Class<? extends IGridElement> target) throws ProblemException {
        boolean result;
        boolean bl = result = target == null;
        if (target != null) {
            if (this.targetMatcher == null) {
                this.initTargetMatcher();
            }
            if (this.targetMatcher.matches(target)) {
                result = true;
            }
        }
        return result;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IGridElementCreator getElementCreator() {
        if (this.elementCreator == null) {
            try {
                this.elementCreator = (IGridElementCreator)this.configurationElement.createExecutableExtension("class");
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return this.elementCreator;
    }

    public String toString() {
        return "ElementCreatorReference@" + this.configurationElement.getAttribute("id");
    }

    private void initSourceMatchers() throws ProblemException {
        IConfigurationElement[] children;
        this.sourceMatchers = new ArrayList<SourceMatcher>();
        IConfigurationElement[] iConfigurationElementArray = children = this.configurationElement.getChildren("source");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.sourceMatchers.add(new SourceMatcher(child));
            ++n2;
        }
    }

    private void initTargetMatcher() throws ProblemException {
        IConfigurationElement[] children = this.configurationElement.getChildren("target");
        this.targetMatcher = new TargetMatcher(children[0]);
    }

    private static class SourceMatcher {
        private static final int DEFAULT_PRIORITY = 50;
        private Class<?> sourceClass;
        private Pattern sourcePattern;
        private int sourcePriority;
        private boolean sourceDefault;
        private ICreatorSourceMatcher sourceMatcher;

        /*
         * Unable to fully structure code
         */
        SourceMatcher(IConfigurationElement element) throws ProblemException {
            super();
            srcclsatt = element.getAttribute("class");
            srccntr = element.getContributor().getName();
            bundle = Platform.getBundle((String)srccntr);
            if (bundle != null) {
                try {
                    this.sourceClass = bundle.loadClass(srcclsatt);
                }
                catch (ClassNotFoundException cnfExc) {
                    idatt = ((IConfigurationElement)element.getParent()).getAttribute("id");
                    throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.source_class_loading_failed"), new Object[]{srcclsatt, idatt}), (Throwable)cnfExc, "eu.geclipse.core");
                }
            } else {
                throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.source_bundle_loading_failed"), new Object[]{srccntr, srcclsatt}), "eu.geclipse.core");
            }
            srcptrnatt = element.getAttribute("pattern");
            if (srcptrnatt != null) {
                try {
                    this.sourcePattern = Pattern.compile(srcptrnatt);
                }
                catch (PatternSyntaxException v0) {
                    idatt = ((IConfigurationElement)element.getParent()).getAttribute("id");
                    throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.invalid_source_pattern"), new Object[]{srcptrnatt, idatt}), "eu.geclipse.core");
                }
            }
            if ((srcprrtyatt = element.getAttribute("priority")) != null) {
                try {
                    this.sourcePriority = Integer.parseInt(srcprrtyatt);
                    if (this.sourcePriority < 1) {
                        this.sourcePriority = 1;
                    }
                    if (this.sourcePriority <= 99) ** GOTO lbl33
                    this.sourcePriority = 99;
                }
                catch (NumberFormatException v1) {
                    throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", Messages.getString("ElementCreatorReference.invalid_priority"), "eu.geclipse.core");
                }
            } else {
                this.sourcePriority = 50;
            }
lbl33:
            // 4 sources

            srcdfltatt = element.getAttribute("default");
            this.sourceDefault = srcdfltatt != null ? Boolean.parseBoolean(srcdfltatt) : false;
            srcmtchratt = element.getAttribute("matcher");
            if (srcmtchratt != null) {
                try {
                    this.sourceMatcher = (ICreatorSourceMatcher)element.createExecutableExtension("matcher");
                }
                catch (CoreException cExc) {
                    idatt = ((IConfigurationElement)element.getParent()).getAttribute("id");
                    throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.source_matcher_loading_failed"), new Object[]{srcmtchratt, idatt}), (Throwable)cExc, "eu.geclipse.core");
                }
            }
        }

        public int getPriority() {
            return this.sourcePriority;
        }

        public boolean isDefault() {
            return this.sourceDefault;
        }

        public boolean matches(Object source) {
            boolean result = false;
            if (source instanceof Class) {
                result = this.sourceClass.isAssignableFrom((Class)source);
            } else {
                result = this.sourceClass.isAssignableFrom(source.getClass());
                if (result && this.sourcePattern != null) {
                    result = this.sourcePattern.matcher(source.toString()).matches();
                }
                if (result && this.sourceMatcher != null) {
                    result = this.sourceMatcher.canCreate(source);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TargetMatcher {
        private Class<?> targetClass;
        private String targetName;

        TargetMatcher(IConfigurationElement element) throws ProblemException {
            String trgtclsatt = element.getAttribute("class");
            String trgtcntr = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)trgtcntr);
            if (bundle != null) {
                try {
                    this.targetClass = bundle.loadClass(trgtclsatt);
                }
                catch (ClassNotFoundException cnfExc) {
                    String idatt = ((IConfigurationElement)element.getParent()).getAttribute("id");
                    throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.target_class_loading_failed"), trgtclsatt, idatt), (Throwable)cnfExc, "eu.geclipse.core");
                }
            } else {
                throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", String.format(Messages.getString("ElementCreatorReference.target_bundle_loading_failed"), trgtcntr, trgtclsatt), "eu.geclipse.core");
            }
            this.targetName = element.getAttribute("name");
        }

        public String getName() {
            return this.targetName;
        }

        public boolean matches(Class<? extends IGridElement> target) {
            return target.isAssignableFrom(this.targetClass);
        }
    }
}

