/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.ElementCreatorReference;
import eu.geclipse.core.model.IElementCreatorRegistry;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCreatorRegistry
implements IElementCreatorRegistry,
IRegistryEventListener {
    private static ElementCreatorRegistry singleton;
    private List<ElementCreatorReference> creators;

    private ElementCreatorRegistry() {
        this.init();
        Platform.getExtensionRegistry().addListener((IRegistryEventListener)this, "eu.geclipse.core.gridElementCreator");
    }

    public static ElementCreatorRegistry getRegistry() {
        if (singleton == null) {
            singleton = new ElementCreatorRegistry();
        }
        return singleton;
    }

    @Override
    public List<IConfigurationElement> getConfigurations() {
        return this.getConfigurations(null, null);
    }

    @Override
    public List<IConfigurationElement> getConfigurations(Class<? extends Object> source, Class<? extends IGridElement> target) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        List<ElementCreatorReference> references = this.findReferences(source, target);
        if (!references.isEmpty()) {
            for (ElementCreatorReference reference : references) {
                IConfigurationElement configuration = reference.getConfigurationElement();
                if (configuration == null) continue;
                result.add(configuration);
            }
        }
        return result;
    }

    @Override
    public IGridElementCreator getCreator(Class<? extends Object> source, Class<? extends IGridElement> target) {
        return this.getCreator((Object)source, target);
    }

    @Override
    public IGridElementCreator getCreator(Object source, String targetClassName) throws ProblemException {
        IGridElementCreator creator = null;
        List<IConfigurationElement> elements = this.getConfigurations(source.getClass(), IGridElement.class);
        try {
            for (IConfigurationElement element : elements) {
                String contributor = element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributor);
                try {
                    IConfigurationElement[] targetElements;
                    Class serviceClass = bundle.loadClass(targetClassName);
                    IConfigurationElement[] iConfigurationElementArray = targetElements = element.getChildren("target");
                    int n = targetElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement targetElement = iConfigurationElementArray[n2];
                        String targetType = targetElement.getAttribute("class");
                        Class targetClass = bundle.loadClass(targetType);
                        if (targetClass.isAssignableFrom(serviceClass)) {
                            creator = (IGridElementCreator)element.createExecutableExtension("class");
                            creator.setSource(source);
                            break;
                        }
                        ++n2;
                    }
                    if (creator == null) continue;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return creator;
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.core");
        }
    }

    @Override
    public IGridElementCreator getCreator(Object source, Class<? extends IGridElement> target) {
        IGridElementCreator result = null;
        List<ElementCreatorReference> references = this.findReferences(source, target);
        int priority = -1;
        if (!references.isEmpty()) {
            for (ElementCreatorReference ref : references) {
                try {
                    int p = ref.checkSource(source);
                    if (p <= priority || (result = ref.getElementCreator()) == null) continue;
                    priority = p;
                }
                catch (ProblemException pExc) {
                    Activator.logException(pExc);
                }
            }
        }
        if (result != null && !(source instanceof Class)) {
            result.setSource(source);
        }
        return result;
    }

    @Override
    public List<IGridElementCreator> getCreators() {
        return this.getCreators(null, null);
    }

    @Override
    public List<IGridElementCreator> getCreators(Class<? extends Object> source, Class<? extends IGridElement> target) {
        return this.getCreators((Object)source, target);
    }

    @Override
    public List<IGridElementCreator> getCreators(Object source, Class<? extends IGridElement> target) {
        ArrayList<IGridElementCreator> result = new ArrayList<IGridElementCreator>();
        List<ElementCreatorReference> references = this.findReferences(source, target);
        if (!references.isEmpty()) {
            for (ElementCreatorReference reference : references) {
                IGridElementCreator creator = reference.getElementCreator();
                if (creator == null) continue;
                if (!(source instanceof Class)) {
                    creator.setSource(source);
                }
                result.add(creator);
            }
        }
        return result;
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                ElementCreatorReference creator = this.findReference(element);
                if (creator == null) {
                    this.creators.add(new ElementCreatorReference(element));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                ElementCreatorReference reference = this.findReference(element);
                if (reference != null) {
                    this.creators.remove(reference);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private ElementCreatorReference findReference(IConfigurationElement element) {
        ElementCreatorReference result = null;
        for (ElementCreatorReference creator : this.creators) {
            if (!creator.getConfigurationElement().equals((Object)element)) continue;
            result = creator;
            break;
        }
        return result;
    }

    private List<ElementCreatorReference> findReferences(Object source, Class<? extends IGridElement> target) {
        ArrayList<ElementCreatorReference> result = new ArrayList<ElementCreatorReference>();
        for (ElementCreatorReference reference : Collections.synchronizedCollection(this.creators)) {
            try {
                if (reference.checkSource(source) == -1 || !reference.checkTarget(target)) continue;
                result.add(reference);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
        return result;
    }

    private void init() {
        this.creators = new ArrayList<ElementCreatorReference>();
        ExtensionManager manager = new ExtensionManager();
        List<IConfigurationElement> configurationElements = manager.getConfigurationElements("eu.geclipse.core.gridElementCreator", "creator");
        for (IConfigurationElement element : configurationElements) {
            this.creators.add(new ElementCreatorReference(element));
        }
    }
}

