/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.JobManager;
import eu.geclipse.core.internal.model.ServiceJobManager;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import eu.geclipse.core.internal.model.notify.ResourceNotificationService;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.model.IManageable;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public final class GridRoot
extends ResourceGridContainer
implements IGridRoot {
    private static GridRoot singleton;

    private GridRoot() {
        super((IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.addGridModelListener(JobManager.getManager());
        this.addGridModelListener(ServiceJobManager.getManager());
        GridRoot.getGridNotificationService();
        GridRoot.getResourceNotificationService();
    }

    public static final GridRoot getInstance() {
        if (singleton == null) {
            singleton = new GridRoot();
        }
        return singleton;
    }

    public static GridNotificationService getGridNotificationService() {
        return GridNotificationService.getInstance();
    }

    public IGridContainer getParent() {
        return null;
    }

    public static ResourceNotificationService getResourceNotificationService() {
        return ResourceNotificationService.getInstance();
    }

    public static final GridRoot getRoot() {
        return singleton;
    }

    public void addGridModelListener(IGridModelListener listener) {
        GridRoot.getGridNotificationService().addListener(listener);
    }

    public boolean canContain(IGridElement element) {
        return element instanceof IGridProject;
    }

    public final IGridElement findElement(IPath path) {
        IGridElement element = path.isRoot() ? this : null;
        String[] segments = path.segments();
        IGridContainer container = this;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            element = container.findChild(segment);
            if (!(element instanceof IGridContainer)) break;
            container = element;
            ++n2;
        }
        return element;
    }

    public final IGridElement findElement(IResource resource) {
        IGridElement result = null;
        IPath path = resource.getFullPath();
        if (path.segmentCount() == 0 && !path.isEmpty()) {
            result = GridModel.getRoot();
        } else {
            IGridContainer parent = this;
            int i = 0;
            while (i < path.segmentCount()) {
                String name = path.segment(i);
                IGridElement element = parent.findChildWithResource(name);
                if (i == path.segmentCount() - 1) {
                    result = element;
                } else if (element instanceof IGridContainer) {
                    parent = (IGridContainer)element;
                }
                ++i;
            }
        }
        return result;
    }

    public void fireGridModelEvent(IGridModelEvent event) {
        GridRoot.getGridNotificationService().queueEvent(event);
    }

    public static void registerElement(IGridElement element) {
        if (element instanceof IManageable) {
            IGridElementManager manager = ((IManageable)element).getManager();
            try {
                manager.addElement(element);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
    }

    public void removeGridModelListener(IGridModelListener listener) {
        GridRoot.getGridNotificationService().removeListener(listener);
    }
}

