/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenProject
extends ResourceGridContainer
implements IGridProject,
IGridPreferences {
    public static final String NAME = ".geclipse";
    private static final String DIR_GLOBAL_CONNECTIONS = ".connections";
    private static final String DIR_TEMP = ".temp";
    private static final String TEMP_CONNECTION_NAME = ".tmp_connection";

    private HiddenProject(IProject project) {
        super((IResource)project);
    }

    public static HiddenProject getInstance() throws ProblemException {
        IGridRoot gridRoot = GridModel.getRoot();
        HiddenProject result = (HiddenProject)gridRoot.findChild(NAME);
        if (result == null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = NAME;
            IProject project = workspaceRoot.getProject(projectName);
            result = HiddenProject.getInstance(project);
        }
        return result;
    }

    static HiddenProject getInstance(IProject project) throws ProblemException {
        if (!project.exists()) {
            String projectName = project.getName();
            IPath projectPath = null;
            IStatus status = ResourcesPlugin.getWorkspace().validateProjectLocation(project, projectPath);
            if (status.getSeverity() != 0) {
                throw new ProblemException("eu.geclipse.core.problem.model.preferenceCreationFailed", status.getMessage(), status.getException(), "eu.geclipse.core");
            }
            IProjectDescription desc = project.getWorkspace().newProjectDescription(projectName);
            desc.setLocation(projectPath);
            try {
                project.create(desc, null);
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.preferenceCreationFailed", (Throwable)cExc, "eu.geclipse.core");
            }
        }
        return new HiddenProject(project);
    }

    @Override
    public boolean canContain(IGridElement element) {
        return true;
    }

    @Override
    public void createGlobalConnection(String name, URI masterURI, IProgressMonitor monitor) throws ProblemException {
        try {
            IFolder folder = this.getGlobalConnectionsFolder();
            IFileStore fileStore = EFS.getStore((URI)masterURI);
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (fileInfo.isDirectory()) {
                IFolder connection = folder.getFolder(name);
                connection.createLink(masterURI, 16, monitor);
            } else {
                IFile connection = folder.getFile(name);
                connection.createLink(masterURI, 16, monitor);
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", (Throwable)cExc, "eu.geclipse.core");
        }
    }

    @Override
    public IGridConnection createTemporaryConnection(URI masterURI) throws ProblemException {
        IGridConnection result = null;
        try {
            IFolder folder = this.getTemporaryFolder();
            IFolder connection = folder.getFolder(TEMP_CONNECTION_NAME);
            if (connection.exists()) {
                connection.delete(true, null);
            }
            connection.createLink(masterURI, 272, null);
            result = (IGridConnection)GridModel.getConnectionManager().findChild(TEMP_CONNECTION_NAME);
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", (Throwable)cExc, "eu.geclipse.core");
        }
        return result;
    }

    @Override
    public IGridProject getProject() {
        return this;
    }

    @Override
    public IGridContainer getProjectFolder(Class<? extends IGridElement> elementType) {
        return null;
    }

    @Override
    public IGridContainer getProjectFolder(IGridElement element) {
        return null;
    }

    @Override
    public String getProjectFolderID(IGridContainer folder) {
        return null;
    }

    @Override
    public IVirtualOrganization getVO() {
        return null;
    }

    @Override
    public boolean hasGridNature() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return ((IProject)this.getResource()).isOpen();
    }

    @Override
    protected IStatus fetchChildren(IProgressMonitor monitor) {
        IStatus result = Status.CANCEL_STATUS;
        if (this.isOpen()) {
            result = super.fetchChildren(monitor);
        }
        return result;
    }

    protected IProject getAccessibleProject() throws ProblemException {
        IProject project = (IProject)this.getResource();
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException exception) {
                throw new ProblemException("eu.geclipse.core.problem.io.openProjectFailed", (Throwable)exception, "eu.geclipse.core");
            }
        }
        return project;
    }

    protected IFolder getGlobalConnectionsFolder() throws CoreException {
        IFolder folder = this.getProjectFolder(DIR_GLOBAL_CONNECTIONS);
        return folder;
    }

    @Override
    public IFolder getTemporaryFolder() throws ProblemException {
        IFolder folder = this.getProjectFolder(DIR_TEMP);
        return folder;
    }

    private IFolder getProjectFolder(String name) throws ProblemException {
        IProject project = this.getAccessibleProject();
        IFolder folder = project.getFolder((IPath)new Path(name));
        if (!folder.exists()) {
            try {
                folder.create(1, true, null);
            }
            catch (CoreException exception) {
                String msg = String.format("Couldn't create folder %s in project %s", name, project.getName());
                throw new ProblemException("eu.geclipse.core.problem.io.crateFolderFailed", msg, (Throwable)exception, "eu.geclipse.core");
            }
        }
        return folder;
    }
}

