/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.JobStatusUpdater;
import eu.geclipse.core.internal.model.AbstractGridElementManager;
import eu.geclipse.core.internal.model.JobScheduler;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobManager;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobManager
extends AbstractGridElementManager
implements IGridJobManager,
IGridJobStatusListener,
IGridModelListener {
    private static final String NAME = ".jobs";
    private static JobManager singleton;
    Hashtable<IGridJobID, JobStatusUpdater> updaters = new Hashtable();
    private List<IGridJobStatusListener> globalListeners = new ArrayList<IGridJobStatusListener>();

    private JobManager() {
    }

    @Override
    public boolean addElement(IGridElement element) throws ProblemException {
        JobStatusUpdater updater;
        boolean flag = super.addElement(element);
        if (element instanceof IGridJob && (updater = this.getUpdater((IGridJob)element)) != null) {
            updater.setSystem(true);
            JobScheduler.getJobScheduler().scheduleNewUpdater(updater);
            updater.addJobStatusListener(255, this);
        }
        return flag;
    }

    @Override
    public void pauseAllUpdaters() {
        JobScheduler.getJobScheduler().pauseAllUpdaters();
    }

    public void pauseUpdater(JobStatusUpdater updater) {
        JobScheduler.getJobScheduler().pauseUpdater(updater);
    }

    public void pauseUpdater(IGridJobID jobId) {
        JobStatusUpdater updater = this.updaters.get(jobId);
        if (updater != null) {
            JobScheduler.getJobScheduler().pauseUpdater(updater);
        }
    }

    @Override
    public void wakeUpAllUpdaters() {
        JobScheduler.getJobScheduler().resumeAllUpdaters();
    }

    @Override
    public void updateJobsStatus(ArrayList<IGridJob> selectedJobs) {
        Enumeration<IGridJobID> enumJobIds = this.updaters.keys();
        while (enumJobIds.hasMoreElements()) {
            IGridJobID jobId = enumJobIds.nextElement();
            for (IGridJob selectedJob : selectedJobs) {
                if (jobId != selectedJob.getID()) continue;
                JobStatusUpdater updater = this.updaters.get(jobId);
                updater.sleep();
                updater.wakeUp();
                updater.schedule(1000L);
            }
        }
    }

    public static JobManager getManager() {
        if (singleton == null) {
            singleton = new JobManager();
        }
        return singleton;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean canManage(IGridElement element) {
        return element instanceof IGridJob;
    }

    @Override
    public void addJobStatusListener(IGridJobStatusListener listener) {
        if (!this.globalListeners.contains(listener)) {
            this.globalListeners.add(listener);
        }
    }

    @Override
    public void addJobStatusListener(IGridJob[] jobs, int status, IGridJobStatusListener listener) {
        JobStatusUpdater updater = null;
        IGridJob[] iGridJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            IGridJob job = iGridJobArray[n2];
            updater = this.getUpdater(job);
            if (updater != null) {
                updater.addJobStatusListener(status, listener);
            }
            ++n2;
        }
    }

    @Override
    public void removeJobStatusListener(IGridJobStatusListener listener) {
        Enumeration<JobStatusUpdater> e = this.updaters.elements();
        while (e.hasMoreElements()) {
            JobStatusUpdater updater = e.nextElement();
            updater.removeJobStatusListener(listener);
        }
        this.globalListeners.remove(listener);
    }

    @Override
    public void removeJobStatusUpdater(IGridJob job, boolean waitForUpdater, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        JobStatusUpdater updater = this.updaters.get(job.getID());
        if (updater != null) {
            JobScheduler.getJobScheduler().clearUpdater(updater);
            updater.setRemoved();
            updater.cancel();
            if (waitForUpdater) {
                while (updater.getState() == 4) {
                    if (subMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public void statusChanged(IGridJob job) {
        for (IGridJobStatusListener listener : this.globalListeners) {
            listener.statusChanged(job);
        }
    }

    @Override
    public void statusUpdated(IGridJob job) {
        for (IGridJobStatusListener listener : this.globalListeners) {
            listener.statusUpdated(job);
        }
    }

    void waitForJob(IGridJob job) throws InterruptedException, NoSuchElementException {
        JobStatusUpdater updater = this.getUpdater(job);
        if (updater == null) {
            throw new NoSuchElementException();
        }
        updater.join();
    }

    @Override
    public void removeJobStatusListener(IGridJob[] jobs, IGridJobStatusListener listener) {
        int i = 0;
        while (i < jobs.length) {
            JobStatusUpdater updater = this.updaters.get(jobs[i].getID());
            if (updater != null) {
                updater.removeJobStatusListener(listener);
            }
            ++i;
        }
        this.globalListeners.remove(listener);
    }

    public void removeJobStatusListener(IGridJobID[] ids, IGridJobStatusListener listener) {
        int i = 0;
        while (i < ids.length) {
            JobStatusUpdater updater = this.updaters.get(ids[i]);
            if (updater != null) {
                updater.removeJobStatusListener(listener);
            }
            ++i;
        }
        this.globalListeners.remove(listener);
    }

    @Override
    public void gridModelChanged(IGridModelEvent event) {
        if (event.getType() == 2) {
            IGridElement[] removedElements;
            IGridElement[] iGridElementArray = removedElements = event.getElements();
            int n = removedElements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement elem = iGridElementArray[n2];
                if (elem instanceof IGridJob) {
                    IGridJob job = (IGridJob)elem;
                    this.removeJobStatusUpdater(job, true, null);
                }
                ++n2;
            }
        }
    }

    @Override
    public void jobStatusChanged(IGridJob job, IGridJobStatus oldStatus) {
        JobStatusUpdater updater = this.getUpdater(job);
        if (updater != null) {
            updater.statusUpdated(job.getJobStatus());
        } else {
            IGridJobStatus newStatus = job.getJobStatus();
            boolean statusChanged = oldStatus.getType() != newStatus.getType();
            for (IGridJobStatusListener listener : this.globalListeners) {
                if (statusChanged) {
                    listener.statusChanged(job);
                }
                listener.statusUpdated(job);
            }
        }
    }

    public JobStatusUpdater getUpdater(IGridJob job) {
        JobStatusUpdater result = null;
        if (!this.updaters.containsKey(job.getID())) {
            if (job.getJobStatus().canChange()) {
                JobStatusUpdater updater = new JobStatusUpdater(job);
                this.updaters.put(job.getID(), updater);
                result = updater;
            }
        } else {
            result = this.updaters.get(job.getID());
        }
        return result;
    }
}

