/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.ResourceCategoryContainer;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.model.IGridApplicationManager;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectVo
extends AbstractGridContainer
implements IVirtualOrganization,
IWrappedElement {
    public static final IGridResourceCategory[] standardCategories = new IGridResourceCategory[]{GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.applications"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.computing"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.data"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.info"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.jobs"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.others"), GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.storage")};
    private static final String NA_STRING = "N/A";
    private IGridProject project;
    private String voName;

    protected ProjectVo(IGridProject project, IVirtualOrganization vo) {
        IGridResourceCategory[] supportedCategories;
        this.project = project;
        this.voName = vo.getName();
        IGridResourceCategory[] iGridResourceCategoryArray = supportedCategories = vo.getSupportedCategories();
        int n = supportedCategories.length;
        int n2 = 0;
        while (n2 < n) {
            IGridResourceCategory category = iGridResourceCategoryArray[n2];
            try {
                this.getResourceContainer(category);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
            ++n2;
        }
    }

    public boolean canContain(IGridElement element) {
        return element instanceof ResourceCategoryContainer;
    }

    public String getTypeName() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getTypeName() : NA_STRING;
    }

    public IGridApplicationManager getApplicationManager() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getApplicationManager() : null;
    }

    public IGridResource[] getAvailableResources(IGridResourceCategory category, boolean exclusive, IProgressMonitor monitor) throws ProblemException {
        IGridInfoService infoService;
        IGridResource[] result = null;
        IVirtualOrganization vo = this.getSlave();
        if (vo != null && (infoService = vo.getInfoService()) != null) {
            result = infoService.fetchResources(this, vo, category, false, null, monitor);
        }
        return result;
    }

    public IGridComputing[] getComputing(IProgressMonitor monitor) throws ProblemException {
        IGridInfoService infoService;
        IGridResource[] resources;
        IGridComputing[] result = null;
        IVirtualOrganization vo = this.getSlave();
        if (vo != null && (resources = (infoService = vo.getInfoService()).fetchResources(this, vo, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.computing"), false, IGridComputing.class, monitor)) != null) {
            result = new IGridComputing[resources.length];
            int i = 0;
            while (i < resources.length) {
                result[i] = (IGridComputing)resources[i];
                ++i;
            }
        }
        return result;
    }

    public IFileStore getFileStore() {
        return this.getProject().getFileStore().getChild(this.getName());
    }

    public IGridInfoService getInfoService() throws ProblemException {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getInfoService() : null;
    }

    public String getName() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getName() : "Vo-Wrapper";
    }

    public IGridContainer getParent() {
        return this.project;
    }

    public IPath getPath() {
        return this.project.getPath().append(this.getName());
    }

    public IGridProject getProject() {
        return this.project;
    }

    public IResource getResource() {
        return null;
    }

    public IGridService[] getServices(IProgressMonitor monitor) throws ProblemException {
        IGridInfoService infoService;
        IGridResource[] resources;
        IGridService[] result = null;
        IVirtualOrganization vo = this.getSlave();
        if (vo != null && (resources = (infoService = vo.getInfoService()).fetchResources(this, vo, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services"), false, IGridService.class, monitor)) != null) {
            result = new IGridService[resources.length];
            int i = 0;
            while (i < resources.length) {
                result[i] = (IGridService)resources[i];
                ++i;
            }
        }
        return result;
    }

    public IGridStorage[] getStorage(IProgressMonitor monitor) throws ProblemException {
        IGridInfoService infoService;
        IGridResource[] resources;
        IGridStorage[] result = null;
        IVirtualOrganization vo = this.getSlave();
        if (vo != null && (resources = (infoService = vo.getInfoService()).fetchResources(this, vo, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.storage"), false, IGridStorage.class, monitor)) != null) {
            result = new IGridStorage[resources.length];
            int i = 0;
            while (i < resources.length) {
                result[i] = (IGridStorage)resources[i];
                ++i;
            }
        }
        return result;
    }

    public IGridResourceCategory[] getSupportedCategories() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getSupportedCategories() : standardCategories;
    }

    public IGridJobService[] getJobSubmissionServices(IProgressMonitor monitor) throws ProblemException {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getJobSubmissionServices(monitor) : new IGridJobService[]{};
    }

    public IGridElement getWrappedElement() {
        return this.getSlave();
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getAdapter(adapter) : null;
    }

    public void load() throws ProblemException {
    }

    public void refresh(IProgressMonitor monitor) throws ProblemException {
        IGridElement[] children = this.getChildren(null);
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Refreshing VO resources", (int)children.length);
        IGridElement[] iGridElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement elem = iGridElementArray[n2];
            if (elem instanceof IGridContainer) {
                ((IGridContainer)elem).refresh((IProgressMonitor)sMonitor.newChild(1));
            }
            ++n2;
        }
    }

    public void refreshResources(IGridResourceCategory category, IProgressMonitor monitor) throws ProblemException {
        ResourceCategoryContainer container = this.getResourceContainer(category);
        if (container != null) {
            container.refresh(monitor);
        }
    }

    public void save() throws ProblemException {
    }

    public void setDirty() {
        try {
            IGridElement[] iGridElementArray = this.getChildren(null);
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement child = iGridElementArray[n2];
                if (child instanceof IGridContainer) {
                    ((IGridContainer)child).setDirty();
                }
                ++n2;
            }
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    public String getWizardId() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getWizardId() : null;
    }

    protected IVirtualOrganization getSlave() {
        IVirtualOrganization result = (IVirtualOrganization)VoManager.getManager().findChild(this.voName);
        return result;
    }

    private ResourceCategoryContainer getResourceContainer(IGridResourceCategory category) throws ProblemException {
        ResourceCategoryContainer result = null;
        String name = category.getName();
        IGridResourceCategory parentCategory = category.getParent();
        AbstractGridContainer parentContainer = parentCategory == null ? this : this.getResourceContainer(parentCategory);
        IGridElement child = parentContainer.findChild(name);
        if (child == null || !(child instanceof ResourceCategoryContainer)) {
            result = new ResourceCategoryContainer((IGridContainer)parentContainer, category);
            if (parentContainer == this) {
                this.addElement(result);
            } else {
                ((ResourceCategoryContainer)parentContainer).addChild(result);
            }
        } else {
            result = (ResourceCategoryContainer)child;
        }
        return result;
    }

    public String getId() {
        IVirtualOrganization vo = this.getSlave();
        return vo != null ? vo.getId() : NA_STRING;
    }
}

