/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.internal.model.Messages;
import eu.geclipse.core.internal.model.VirtualGridContainer;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IGridResourceContainer;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ResourceCategoryContainer
extends VirtualGridContainer
implements IGridResourceContainer {
    private IGridResourceCategory category;
    private List<IGridElement> permanentChildren = new ArrayList<IGridElement>();

    protected ResourceCategoryContainer(IGridContainer parent, IGridResourceCategory category) {
        super(parent, category.getName());
        this.category = category;
        if (parent instanceof ResourceCategoryContainer) {
            ((ResourceCategoryContainer)parent).permanentChildren.add(this);
        }
    }

    public void addChild(ResourceCategoryContainer child) throws ProblemException {
        this.addElement(child);
    }

    public boolean canContain(IGridElement element) {
        return element instanceof IGridResource || element instanceof ResourceCategoryContainer || element instanceof ContainerMarker;
    }

    public IGridResourceCategory getCategory() {
        return this.category;
    }

    public boolean isLocal() {
        return true;
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) throws ProblemException {
        for (IGridElement permantenChild : this.permanentChildren) {
            this.addElement(permantenChild);
        }
        if (this.category.isActive()) {
            IGridResource[] resources = this.getProject().getVO().getAvailableResources(this.category, true, monitor);
            if (resources != null && resources.length > 0) {
                this.lock();
                try {
                    IGridResource[] iGridResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGridResource resource = iGridResourceArray[n2];
                        this.addElement(resource);
                        ++n2;
                    }
                }
                finally {
                    this.unlock();
                }
            } else {
                this.addElement(new ContainerMarker(this, ContainerMarker.MarkerType.INFO, Messages.getString("ResourceCategoryContainer.no_matching_elements_error")));
            }
        }
        return Status.OK_STATUS;
    }
}

