/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.AbstractDefaultGridElementManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IElementCreatorRegistry;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;

public class VoManager
extends AbstractDefaultGridElementManager
implements IVoManager {
    public static final String NAME = ".vos";
    private static VoManager singleton;

    private VoManager() {
        try {
            this.loadElements();
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    public static VoManager getManager() {
        if (singleton == null) {
            singleton = new VoManager();
        }
        return singleton;
    }

    public static IFileStore getVoManagerStore() {
        IFileStore managerStore = VoManager.getManagerStore();
        IFileStore childStore = managerStore.getChild(NAME);
        IFileInfo childInfo = childStore.fetchInfo();
        if (!childInfo.exists()) {
            try {
                childStore.mkdir(0, null);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return childStore;
    }

    public boolean canManage(IGridElement element) {
        return element instanceof IVirtualOrganization;
    }

    public String getName() {
        return NAME;
    }

    public void loadElements() throws ProblemException {
        IFileStore[] childStores;
        IFileStore fileStore = this.getFileStore();
        try {
            childStores = fileStore.childStores(0, null);
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.core");
        }
        IElementCreatorRegistry registry = GridModel.getCreatorRegistry();
        IFileStore[] iFileStoreArray = childStores;
        int n = childStores.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore childStore = iFileStoreArray[n2];
            try {
                IGridElementCreator creator = registry.getCreator((Object)childStore, IVirtualOrganization.class);
                if (creator != null) {
                    this.create(creator);
                }
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
            ++n2;
        }
        String defaultVoName = Preferences.getDefaultVoName();
        if (defaultVoName != null) {
            IGridElement defaultVo = this.findChild(defaultVoName);
            this.setDefault(defaultVo);
        }
        if (this.hasChildren()) {
            this.updateDefault();
        }
    }

    public void saveElements() throws ProblemException {
        IGridElement[] elements;
        IGridElement[] iGridElementArray = elements = this.getChildren(null);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement element = iGridElementArray[n2];
            if (element instanceof IStorableElement) {
                ((IStorableElement)element).save();
            }
            ++n2;
        }
        IVirtualOrganization defaultVo = (IVirtualOrganization)this.getDefault();
        if (defaultVo != null) {
            Preferences.setDefaultVoName(defaultVo.getName());
            Preferences.save();
        }
    }
}

