/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import org.eclipse.core.runtime.Assert;

public class GridModelEvent
implements IGridModelEvent {
    private int type;
    private IGridElement source;
    private IGridElement[] elements;

    public GridModelEvent(int type, IGridElement source, IGridElement[] elements) {
        Assert.isNotNull((Object)source);
        this.type = type;
        this.source = source;
        this.elements = null;
        if (elements != null) {
            int length = elements.length;
            this.elements = new IGridElement[length];
            System.arraycopy(elements, 0, this.elements, 0, length);
        }
    }

    public IGridElement[] getElements() {
        return this.elements;
    }

    public IGridElement getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("GridModelEvent(");
        switch (this.type) {
            case 1: {
                buffer.append("ELEMENTS_ADDED, ");
                break;
            }
            case 2: {
                buffer.append("ELEMENTS_REMOVED, ");
                break;
            }
            case 3: {
                buffer.append("ELEMENTS_CHANGED, ");
                break;
            }
            case 5: {
                buffer.append("PROJECT_CLOSED, ");
                break;
            }
            case 6: {
                buffer.append("PROJECT_FOLDER_CHANGES, ");
                break;
            }
            case 4: {
                buffer.append("PROJECT_OPENED, ");
                break;
            }
            default: {
                buffer.append("INVALID, ");
            }
        }
        if (this.source != null) {
            buffer.append(String.valueOf(this.source.getName()) + ", ");
        } else {
            buffer.append("null, ");
        }
        if (this.elements != null) {
            buffer.append("{");
            int i = 0;
            while (i < this.elements.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.elements[i] != null) {
                    buffer.append(this.elements[i].getName());
                } else {
                    buffer.append("null");
                }
                ++i;
            }
            buffer.append("}");
        } else {
            buffer.append("null");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

