/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.model.notify;

import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class GridNotificationService {
    private static GridNotificationService instance;
    private List<IGridModelListener> listeners = new ArrayList<IGridModelListener>();
    private List<IGridModelEvent> eventList = new ArrayList<IGridModelEvent>();
    private Hashtable<IGridElement, Integer> locks = new Hashtable();

    private GridNotificationService() {
    }

    public static GridNotificationService getInstance() {
        if (instance == null) {
            instance = new GridNotificationService();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IGridModelListener listener) {
        List<IGridModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void lock(IGridElement owner) {
        Assert.isNotNull((Object)owner);
        Integer counter = this.locks.get(owner);
        counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
        this.locks.put(owner, counter);
    }

    public void queueEvent(IGridModelEvent event) {
        this.incorporateEvent(event);
        this.processEvents(event.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IGridModelListener listener) {
        List<IGridModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void unlock(IGridElement owner) {
        Assert.isNotNull((Object)owner);
        Integer counter = this.locks.get(owner);
        counter = counter != null ? Integer.valueOf(counter - 1) : Integer.valueOf(0);
        if (counter <= 0) {
            this.locks.remove(owner);
        } else {
            this.locks.put(owner, counter);
        }
        this.processEvents(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incorporateEvent(IGridModelEvent event) {
        IGridElement source = event.getSource();
        int type = event.getType();
        List<IGridModelEvent> list = this.eventList;
        synchronized (list) {
            int index = 0;
            IGridModelEvent oldEvent = null;
            while (index < this.eventList.size()) {
                oldEvent = this.eventList.get(index);
                if (source == oldEvent.getSource() && type == oldEvent.getType()) break;
                ++index;
            }
            if (index < this.eventList.size() && oldEvent != null) {
                IGridElement e;
                IGridElement[] elements = event.getElements();
                IGridElement[] oldElements = oldEvent.getElements();
                ArrayList<IGridElement> newElementList = new ArrayList<IGridElement>();
                IGridElement[] iGridElementArray = oldElements;
                int n = oldElements.length;
                int n2 = 0;
                while (n2 < n) {
                    e = iGridElementArray[n2];
                    newElementList.add(e);
                    ++n2;
                }
                iGridElementArray = elements;
                n = elements.length;
                n2 = 0;
                while (n2 < n) {
                    e = iGridElementArray[n2];
                    if (!newElementList.contains(e)) {
                        newElementList.add(e);
                    }
                    ++n2;
                }
                IGridElement[] newElements = newElementList.toArray(new IGridElement[newElementList.size()]);
                GridModelEvent newEvent = new GridModelEvent(type, source, newElements);
                this.eventList.remove(index);
                this.eventList.add(index, newEvent);
            } else {
                this.eventList.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents(IGridElement owner) {
        Assert.isNotNull((Object)owner);
        Integer counter = this.locks.get(owner);
        if (counter == null || counter <= 0) {
            ArrayList<IGridModelEvent> localCopy = new ArrayList<IGridModelEvent>();
            List<IGridModelEvent> list = this.eventList;
            synchronized (list) {
                for (IGridModelEvent event : this.eventList) {
                    if (owner != null && event.getSource() != owner) continue;
                    localCopy.add(event);
                }
                for (IGridModelEvent event : localCopy) {
                    this.eventList.remove(event);
                }
            }
            for (IGridModelEvent event : localCopy) {
                List<IGridModelListener> list2 = this.listeners;
                synchronized (list2) {
                    for (IGridModelListener listener : this.listeners) {
                        listener.gridModelChanged(event);
                    }
                }
            }
        }
    }
}

