/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.security;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.security.Messages;
import eu.geclipse.core.internal.security.X509CertificateHandle;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.BaseSecurityManager;
import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import java.io.File;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateManager
extends BaseSecurityManager
implements ICertificateManager {
    public static final Pattern CERT_FILE_PATTERN = Pattern.compile(".*\\.[0-9]");
    private static CertificateManager singleton;
    private List<X509CertificateHandle> trusted = new ArrayList<X509CertificateHandle>();
    private List<X509CertificateHandle> untrusted = new ArrayList<X509CertificateHandle>();
    private IPath certificateLocation;

    private CertificateManager() {
        this.update();
    }

    public static CertificateManager getManager() {
        if (singleton == null) {
            singleton = new CertificateManager();
        }
        return singleton;
    }

    public static IPath getDefaultCertificateLocation() {
        File file;
        IPath location = Activator.getDefault().getStateLocation();
        if (!location.hasTrailingSeparator()) {
            location = location.addTrailingSeparator();
        }
        if (!(file = (location = location.append(".security")).toFile()).exists() && !file.mkdir()) {
            Activator.logStatus((IStatus)new Status(2, "eu.geclipse.core", Messages.getString("CertificateManager.cert_location_creation_failed")));
        }
        return location;
    }

    public IPath getCertificateLocation() {
        if (this.certificateLocation == null) {
            this.certificateLocation = CertificateManager.getDefaultCertificateLocation();
        }
        return this.certificateLocation;
    }

    @Override
    public ICertificateHandle addCertificate(X509Certificate c, ICertificateManager.CertTrust trust) throws ProblemException {
        X509CertificateHandle result = this.internalAddCertificate(c, trust);
        if (result != null) {
            this.fireContentChanged();
        }
        return result;
    }

    @Override
    public ICertificateHandle[] addCertificates(X509Certificate[] list, ICertificateManager.CertTrust trust) throws ProblemException {
        ArrayList<X509CertificateHandle> result = new ArrayList<X509CertificateHandle>();
        X509Certificate[] x509CertificateArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate c = x509CertificateArray[n2];
            X509CertificateHandle o = this.internalAddCertificate(c, trust);
            if (o != null) {
                result.add(o);
            }
            ++n2;
        }
        if (!result.isEmpty()) {
            this.fireContentChanged();
        }
        return result.toArray(new X509CertificateHandle[result.size()]);
    }

    public ICertificateHandle findHandle(X509Certificate cert) {
        ICertificateHandle result = null;
        List<ICertificateHandle> certificates = this.getAllCertificates();
        for (ICertificateHandle handle : certificates) {
            if (!handle.getCertificate().equals(cert)) continue;
            result = handle;
            break;
        }
        return result;
    }

    @Override
    public List<ICertificateHandle> getAllCertificates() {
        ArrayList<ICertificateHandle> result = new ArrayList<ICertificateHandle>(this.trusted);
        result.addAll(this.untrusted);
        return result;
    }

    @Override
    public List<ICertificateHandle> getTrustedCertificates() {
        return new ArrayList<ICertificateHandle>(this.trusted);
    }

    public Set<TrustAnchor> getTrustAnchors() {
        List<ICertificateHandle> trustedCertificates = this.getTrustedCertificates();
        HashSet<TrustAnchor> set = new HashSet<TrustAnchor>(trustedCertificates.size());
        for (ICertificateHandle handle : trustedCertificates) {
            set.add(new TrustAnchor(handle.getCertificate(), null));
        }
        return set;
    }

    @Override
    public List<ICertificateHandle> getUntrustedCertificates() {
        return new ArrayList<ICertificateHandle>(this.untrusted);
    }

    @Override
    public void removeCertificate(ICertificateHandle c) {
        if (this.internalRemoveCertificate(c)) {
            this.fireContentChanged();
        }
    }

    @Override
    public void removeCertificates(ICertificateHandle[] list) {
        boolean changed = false;
        ICertificateHandle[] iCertificateHandleArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ICertificateHandle c = iCertificateHandleArray[n2];
            changed |= this.internalRemoveCertificate(c);
            ++n2;
        }
        if (changed) {
            this.fireContentChanged();
        }
    }

    public void setCertificateLocation(IPath location) {
        this.certificateLocation = location;
        this.update();
    }

    private X509CertificateHandle internalAddCertificate(X509Certificate c, ICertificateManager.CertTrust trust) throws ProblemException {
        X509CertificateHandle result = null;
        result = new X509CertificateHandle(c, trust);
        if (trust.isTrusted() && !this.trusted.contains(result)) {
            this.trusted.add(result);
        } else if (!trust.isTrusted() && !this.untrusted.contains(result)) {
            this.untrusted.add(result);
        } else {
            result = null;
        }
        return result;
    }

    private boolean internalRemoveCertificate(ICertificateHandle c) {
        boolean result = false;
        if (c.getTrust().isTrusted() && this.trusted.contains(c) && c.delete()) {
            this.trusted.remove(c);
            result = true;
        } else if (!c.getTrust().isTrusted() && this.untrusted.contains(c) && c.delete()) {
            this.untrusted.remove(c);
            result = true;
        }
        return result;
    }

    private void update() {
        this.trusted.clear();
        File dir = this.getCertificateLocation().toFile();
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (CERT_FILE_PATTERN.matcher(file.getName()).matches()) {
                    try {
                        X509CertificateHandle certificate = new X509CertificateHandle(file);
                        this.trusted.add(certificate);
                    }
                    catch (ProblemException pExc) {
                        Activator.logException(pExc);
                    }
                }
                ++n2;
            }
        }
        this.fireContentChanged();
    }
}

