/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.security;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.security.CertificateManager;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.core.security.ICertificateTrustVerifier;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateTrustVerifier
implements ICertificateTrustVerifier {
    private static CertificateTrustVerifier singleton;
    private List<ICertificateTrustVerifier> verifierList;

    private CertificateTrustVerifier() {
    }

    public static CertificateTrustVerifier getVerifier() {
        if (singleton == null) {
            singleton = new CertificateTrustVerifier();
        }
        return singleton;
    }

    @Override
    public ICertificateTrustVerifier.TrustMode verifyTrust(X509Certificate[] chain) {
        ICertificateTrustVerifier.TrustMode result = ICertificateTrustVerifier.TrustMode.None;
        CertificateManager manager = CertificateManager.getManager();
        X509Certificate[] x509CertificateArray = chain;
        int n = chain.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            ICertificateHandle handle = manager.findHandle(cert);
            if (handle != null) {
                ICertificateManager.CertTrust trust = handle.getTrust();
                if (trust.isTrusted()) {
                    result = ICertificateTrustVerifier.TrustMode.Temporarily;
                } else {
                    result = ICertificateTrustVerifier.TrustMode.Never;
                    break;
                }
            }
            ++n2;
        }
        if (result.equals((Object)ICertificateTrustVerifier.TrustMode.None)) {
            List<ICertificateTrustVerifier> verifiers = this.getVerifiers();
            for (ICertificateTrustVerifier verifier : verifiers) {
                result = verifier.verifyTrust(chain);
                if (!result.isValid()) continue;
                this.handleTrustMode(result, chain);
                break;
            }
        }
        return result;
    }

    private List<ICertificateTrustVerifier> getVerifiers() {
        if (this.verifierList == null) {
            this.verifierList = new ArrayList<ICertificateTrustVerifier>();
            ExtensionManager manager = new ExtensionManager();
            List<Object> list = manager.getExecutableExtensions("eu.geclipse.core.certificateTrustVerifier", "verifier", "class");
            for (Object o : list) {
                this.verifierList.add((ICertificateTrustVerifier)o);
            }
        }
        return this.verifierList;
    }

    private void handleTrustMode(ICertificateTrustVerifier.TrustMode mode, X509Certificate[] chain) {
        if (chain != null && chain.length > 0) {
            try {
                if (mode == ICertificateTrustVerifier.TrustMode.Never) {
                    CertificateManager.getManager().addCertificate(chain[0], ICertificateManager.CertTrust.Untrusted);
                } else if (mode == ICertificateTrustVerifier.TrustMode.Session) {
                    CertificateManager.getManager().addCertificates(chain, ICertificateManager.CertTrust.Trusted);
                } else if (mode == ICertificateTrustVerifier.TrustMode.Permanent) {
                    CertificateManager.getManager().addCertificates(chain, ICertificateManager.CertTrust.AlwaysTrusted);
                }
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
    }
}

