/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.internal.security;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.security.Messages;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ICertificateManager;
import eu.geclipse.core.security.Security;
import eu.geclipse.core.security.X509Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class X509CertificateHandle
implements ICertificateHandle {
    private X509Certificate certificate;
    private File file;
    private ICertificateManager.CertTrust trust;

    public X509CertificateHandle(X509Certificate c, ICertificateManager.CertTrust trust) throws ProblemException {
        if (trust == ICertificateManager.CertTrust.AlwaysTrusted) {
            this.file = this.save(c);
        }
        this.certificate = c;
        this.trust = trust;
    }

    X509CertificateHandle(File f) throws ProblemException {
        this.certificate = this.load(f);
        this.file = f;
        this.trust = ICertificateManager.CertTrust.AlwaysTrusted;
    }

    public boolean delete() {
        return this.file != null ? this.file.delete() : true;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof X509CertificateHandle) {
            result = ((X509CertificateHandle)o).getCertificate().equals(this.getCertificate());
        }
        return result;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public ICertificateManager.CertTrust getTrust() {
        return this.trust;
    }

    private X509Certificate load(File f) throws ProblemException {
        try {
            FileInputStream fis = new FileInputStream(f);
            return X509Util.loadCertificate(fis);
        }
        catch (FileNotFoundException fnfExc) {
            throw new ProblemException("eu.geclipse.core.problem.security.certLoadFailed", String.valueOf(Messages.getString("X509CertificateHandle.load_failed")) + f.getName(), (Throwable)fnfExc, "eu.geclipse.core");
        }
    }

    private File save(X509Certificate c) throws ProblemException {
        File result = null;
        int hash = -1;
        try {
            hash = this.subjectDNHash(c);
        }
        catch (NoSuchAlgorithmException nsaExc) {
            Activator.logStatus((IStatus)new Status(2, "eu.geclipse.core", Messages.getString("X509CertificateHandle.no_md5_hash"), (Throwable)nsaExc));
            hash = c.getSubjectX500Principal().hashCode();
        }
        String name = String.format("%08x", hash);
        IPath filepath = Security.getCertificateLocation().append(name);
        int i = 0;
        while (i <= 9) {
            result = filepath.addFileExtension(String.valueOf(i)).toFile();
            if (!result.exists()) {
                try {
                    X509Util.saveCertificate(c, new FileOutputStream(result));
                    break;
                }
                catch (FileNotFoundException fnfExc) {
                    throw new ProblemException("eu.geclipse.core.problem.security.certSaveFailed", (Throwable)fnfExc, "eu.geclipse.core");
                }
            }
            if (i == 9) {
                throw new ProblemException("eu.geclipse.core.problem.security.certSaveFailed", Messages.getString("X509CertificateHandle.inappropriate_file_name"), "eu.geclipse.core");
            }
            ++i;
        }
        return result;
    }

    private int subjectDNHash(X509Certificate c) throws NoSuchAlgorithmException {
        X500Principal subjectDN = c.getSubjectX500Principal();
        byte[] encoded = subjectDN.getEncoded();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        byte[] digest = md5.digest(encoded);
        int result = digest[0] & 0xFF | (digest[1] & 0xFF) << 8 | (digest[2] & 0xFF) << 16 | (digest[3] & 0xFF) << 24;
        return result;
    }
}

