/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.auth.AbstractAuthTokenProvider;
import eu.geclipse.core.internal.model.GridRoot;
import eu.geclipse.core.internal.model.notify.GridModelEvent;
import eu.geclipse.core.internal.model.notify.GridNotificationService;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IManageable;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.core.model.impl.Messages;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.MasterMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGridContainer
extends AbstractGridElement
implements IGridContainer {
    private final List<IGridElement> children = new ArrayList<IGridElement>();
    private boolean dirty;
    private ChildFetcher fetcher;

    protected AbstractGridContainer() {
        this.setDirty();
    }

    @Override
    public boolean canContain(IGridElement element) {
        return false;
    }

    @Override
    public boolean contains(IGridElement element) {
        return this.children.contains(element);
    }

    @Override
    public IGridElement create(IGridElementCreator creator) throws ProblemException {
        IGridElement element = creator.create(this);
        element = this.addElement(element);
        return element;
    }

    @Override
    public void delete(IGridElement child) throws ProblemException {
        this.removeElement(child);
        this.unregisterFromManager(child);
        child.dispose();
    }

    private void unregisterFromManager(IGridElement child) {
        if (child instanceof IManageable) {
            IGridElementManager manager = ((IManageable)child).getManager();
            manager.removeElement(child);
        }
    }

    @Override
    public void dispose() {
        this.deleteAll();
        super.dispose();
    }

    @Override
    public int getChildCount() {
        int result = this.isLazy() && this.isDirty() ? 1 : this.children.size();
        return result;
    }

    @Override
    public IGridElement[] getChildren(IProgressMonitor monitor) throws ProblemException {
        if (this.isLazy() && this.isDirty()) {
            try {
                this.startFetch(monitor);
            }
            catch (Throwable t) {
                if (t instanceof ProblemException) {
                    throw (ProblemException)t;
                }
                throw new ProblemException("eu.geclipse.core.problem.model.fetchChildrenFailed", t, "eu.geclipse.core");
            }
        }
        return this.children.toArray(new IGridElement[this.children.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.isLazy() || !this.children.isEmpty();
    }

    @Override
    public IGridElement findChild(String name) {
        IGridElement result = null;
        for (IGridElement child : this.children) {
            if (!child.getName().equals(name)) continue;
            result = child;
            break;
        }
        return result;
    }

    @Override
    public IGridElement findChildWithResource(String resourceName) {
        IGridElement result = null;
        for (IGridElement child : this.children) {
            if (child.isVirtual() || !child.getResource().getName().equals(resourceName)) continue;
            result = child;
            break;
        }
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws ProblemException {
        block9: {
            if (!this.isVirtual()) {
                IContainer container = (IContainer)this.getResource();
                try {
                    try {
                        this.lock();
                        container.refreshLocal(2, monitor);
                        break block9;
                    }
                    catch (CoreException cExc) {
                        throw new ProblemException("eu.geclipse.core.problem.model.refreshFailed", (Throwable)cExc, "eu.geclipse.core");
                    }
                }
                finally {
                    this.unlock();
                }
            }
            this.setDirty();
            try {
                this.startFetch(monitor);
            }
            catch (Throwable t) {
                if (t instanceof ProblemException) {
                    throw (ProblemException)t;
                }
                throw new ProblemException("eu.geclipse.core.problem.model.refreshFailed", t, "eu.geclipse.core");
            }
        }
    }

    @Override
    public void setDirty() {
        this.setDirty(true);
    }

    protected IGridElement addElement(IGridElement element) throws ProblemException {
        if (element != null) {
            this.testCanContain(element);
            IGridElement oldChild = this.findChild(element.getName());
            if (oldChild != null) {
                this.delete(oldChild);
            }
            this.children.add(element);
            GridRoot.registerElement(element);
            this.fireGridModelEvent(1, element);
            if (this.isLazy() && !(element instanceof ContainerMarker)) {
                for (IGridElement child : this.children) {
                    if (!(child instanceof ContainerMarker)) continue;
                    this.removeElement(child);
                    break;
                }
            }
        }
        return element;
    }

    @Override
    public void deleteAll() {
        if (this.children != null && !this.children.isEmpty()) {
            for (IGridElement child : this.children) {
                this.unregisterFromManager(child);
                child.dispose();
            }
            IGridElement[] elements = this.children.toArray(new IGridElement[this.children.size()]);
            this.fireGridModelEvent(2, elements);
            this.children.clear();
        }
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) throws ProblemException {
        return Status.OK_STATUS;
    }

    protected void removeElement(IGridElement element) throws ProblemException {
        boolean result = this.children.remove(element);
        if (result) {
            ContainerMarker marker;
            this.fireGridModelEvent(2, element);
            if (this.children.isEmpty() && this.isLazy() && !(element instanceof ContainerMarker) && this.canContain(marker = ContainerMarker.getEmptyFolderMarker(this))) {
                this.addElement(marker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty(boolean d) {
        this.dirty = d;
        if (d) {
            List<IGridElement> synchronizedList;
            if (this.fetcher != null && this.fetcher.isFetching()) {
                this.fetcher.cancel();
            }
            List<IGridElement> list = synchronizedList = Collections.synchronizedList(this.children);
            synchronized (list) {
                for (IGridElement child : synchronizedList) {
                    if (!(child instanceof IGridContainer)) continue;
                    ((IGridContainer)child).setDirty();
                }
            }
        }
    }

    protected void lock() {
        AbstractGridContainer.getGridNotificationService().lock(this);
    }

    protected void unlock() {
        AbstractGridContainer.getGridNotificationService().unlock(this);
    }

    protected void fireGridModelEvent(int type, IGridElement element) {
        this.fireGridModelEvent(type, new IGridElement[]{element});
    }

    protected void fireGridModelEvent(int type, IGridElement[] elements) {
        if (elements != null && elements.length > 0) {
            GridModelEvent event = new GridModelEvent(type, this, elements);
            AbstractGridContainer.getGridNotificationService().queueEvent(event);
        }
    }

    private static GridNotificationService getGridNotificationService() {
        return GridNotificationService.getInstance();
    }

    protected static void staticAddGridModelListener(IGridModelListener listener) {
        AbstractGridContainer.getGridNotificationService().addListener(listener);
    }

    private void startFetch(IProgressMonitor monitor) throws Throwable {
        if (this.fetcher == null) {
            this.fetcher = new ChildFetcher(this);
        }
        this.fetcher.setExternalMonitor(monitor);
        if (!this.fetcher.isFetching() || this.fetcher.isCanceling()) {
            this.fetcher.schedule();
        }
        try {
            this.fetcher.join();
        }
        catch (InterruptedException interruptedException) {}
        Throwable exc = this.fetcher.getException();
        if (exc != null) {
            throw exc;
        }
    }

    private void testCanContain(IGridElement element) throws ProblemException {
        if (!this.canContain(element)) {
            throw new ProblemException("eu.geclipse.core.problem.model.containerCanNotContain", String.format(Messages.getString("AbstractGridContainer.can_not_contain_error"), this.getClass().getName(), element.getClass().getName()), "eu.geclipse.core");
        }
    }

    protected List<IGridElement> getCachedChildren() {
        return this.children;
    }

    private static class ChildFetcher
    extends Job {
        private final AbstractGridContainer container;
        private IProgressMonitor externalMonitor;
        private Throwable exception;
        private boolean canceling;

        public ChildFetcher(AbstractGridContainer container) {
            super("Child Fetcher @ " + container.getName());
            this.container = container;
        }

        public Throwable getException() {
            return this.exception;
        }

        public boolean isFetching() {
            return this.getState() != 0;
        }

        public void setExternalMonitor(IProgressMonitor monitor) {
            this.externalMonitor = monitor;
        }

        protected IStatus run(IProgressMonitor monitor) {
            MasterMonitor mon = new MasterMonitor(monitor, this.externalMonitor);
            this.canceling = false;
            this.exception = null;
            this.container.lock();
            try {
                try {
                    Throwable exc;
                    this.container.deleteAll();
                    IStatus status = this.container.fetchChildren(mon);
                    if (!status.isOK() && !AbstractAuthTokenProvider.isTokenRequestCanceledException(exc = status.getException())) {
                        this.exception = status.getException();
                    }
                }
                catch (Throwable t) {
                    this.exception = t;
                    if (!this.canceling) {
                        this.container.setDirty(false);
                    }
                    this.container.unlock();
                    this.canceling = false;
                }
            }
            finally {
                if (!this.canceling) {
                    this.container.setDirty(false);
                }
                this.container.unlock();
                this.canceling = false;
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.canceling = true;
            super.canceling();
        }

        public boolean isCanceling() {
            return this.canceling;
        }
    }
}

