/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.internal.model.ProjectVo;
import eu.geclipse.core.internal.model.VoManager;
import eu.geclipse.core.model.IGridApplicationManager;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVirtualOrganization
extends AbstractGridContainer
implements IVirtualOrganization {
    protected AbstractVirtualOrganization() {
    }

    @Override
    public boolean canContain(IGridElement element) {
        return element instanceof IGridService || element instanceof IGridApplicationManager;
    }

    @Override
    public void dispose() {
        IFileStore fileStore = this.getFileStore();
        try {
            fileStore.delete(0, null);
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
    }

    @Override
    public IGridApplicationManager getApplicationManager() {
        return null;
    }

    @Override
    public IGridResource[] getAvailableResources(IGridResourceCategory category, boolean exclusive, IProgressMonitor monitor) throws ProblemException {
        IGridResource[] resources = null;
        if (category.equals(GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.jobs"))) {
            resources = this.getJobSubmissionServices(monitor);
        } else if (category.equals(GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services"))) {
            resources = this.getServices(monitor);
        } else {
            IGridInfoService infoService = this.getInfoService();
            if (infoService != null) {
                resources = infoService.fetchResources(this, this, category, false, null, monitor);
            }
        }
        new HashSet();
        return resources;
    }

    public IGridComputing[] getComputing(IProgressMonitor monitor) throws ProblemException {
        IGridComputing[] computing = null;
        IGridInfoService infoService = this.getInfoService();
        IGridResource[] myComputingResources = null;
        if (infoService != null) {
            myComputingResources = infoService.fetchResources(this, this, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.computing"), false, IGridComputing.class, monitor);
            computing = new IGridComputing[myComputingResources.length];
            System.arraycopy(myComputingResources, 0, computing, 0, myComputingResources.length);
        } else {
            computing = new IGridComputing[]{};
        }
        return computing;
    }

    @Override
    public IFileStore getFileStore() {
        IFileStore fileStore = VoManager.getVoManagerStore().getChild(this.getName());
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (!fileInfo.exists()) {
            try {
                fileStore.mkdir(0, null);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return fileStore;
    }

    @Override
    public IGridInfoService getInfoService() throws ProblemException {
        IGridElement[] children;
        IGridInfoService infoService = null;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IGridInfoService) {
                infoService = (IGridInfoService)child;
                break;
            }
            ++n2;
        }
        return infoService;
    }

    @Override
    public IGridContainer getParent() {
        return VoManager.getManager();
    }

    @Override
    public IPath getPath() {
        Path path = new Path(".vos");
        return path.append(this.getName());
    }

    @Override
    public IResource getResource() {
        return null;
    }

    public IGridService[] getServices(IProgressMonitor monitor) throws ProblemException {
        IGridElement[] children;
        IGridResource[] resources = null;
        IGridInfoService infoService = this.getInfoService();
        if (infoService != null) {
            resources = infoService.fetchResources(this, this, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services"), false, IGridService.class, monitor);
        }
        HashSet<IGridResource> resourcesSet = new HashSet<IGridResource>();
        if (resources != null) {
            resourcesSet.addAll((Collection)Arrays.asList(resources));
        }
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IGridService) {
                resourcesSet.add((IGridResource)child);
            }
            ++n2;
        }
        return resourcesSet.toArray(new IGridService[resourcesSet.size()]);
    }

    public IGridStorage[] getStorage(IProgressMonitor monitor) throws ProblemException {
        IGridStorage[] storage = null;
        IGridResource[] myGridStorage = null;
        IGridInfoService infoService = this.getInfoService();
        if (infoService != null) {
            myGridStorage = infoService.fetchResources(this, this, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.storage"), false, IGridStorage.class, monitor);
            storage = new IGridStorage[myGridStorage.length];
            System.arraycopy(myGridStorage, 0, storage, 0, myGridStorage.length);
        } else {
            storage = new IGridStorage[]{};
        }
        return storage;
    }

    @Override
    public IGridResourceCategory[] getSupportedCategories() {
        return ProjectVo.standardCategories;
    }

    @Override
    public IGridJobService[] getJobSubmissionServices(IProgressMonitor monitor) throws ProblemException {
        IGridElement[] children;
        IGridResource[] resources = null;
        IGridInfoService infoService = this.getInfoService();
        if (infoService != null) {
            resources = infoService.fetchResources(this, this, GridResourceCategoryFactory.getCategory("eu.geclipse.core.model.category.services.jobs"), false, IGridJobService.class, monitor);
        }
        HashSet<IGridResource> resourcesSet = new HashSet<IGridResource>();
        if (resources != null) {
            resourcesSet.addAll((Collection)Arrays.asList(resources));
        }
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IGridJobService) {
                resourcesSet.add((IGridResource)child);
            }
            ++n2;
        }
        return resourcesSet.toArray(new IGridJobService[resourcesSet.size()]);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void load() throws ProblemException {
        this.deleteAll();
        IFileStore fileStore = this.getFileStore();
        try {
            IFileStore[] childStores;
            IFileStore[] iFileStoreArray = childStores = fileStore.childStores(0, null);
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IGridElement element = this.loadChild(child.getName());
                if (element != null) {
                    this.addElement(element);
                }
                ++n2;
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.core");
        }
    }

    @Override
    public void refreshResources(IGridResourceCategory category, IProgressMonitor monitor) throws ProblemException {
    }

    @Override
    public void save() throws ProblemException {
        IGridElement[] children;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IStorableElement) {
                ((IStorableElement)child).save();
            } else {
                this.saveChild(child);
            }
            ++n2;
        }
    }

    protected IGridService[] filterServices(IGridService[] services, Class<? extends IGridService> type, boolean remove) {
        ArrayList<IGridService> resultList = new ArrayList<IGridService>();
        IGridService[] iGridServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IGridService service = iGridServiceArray[n2];
            boolean isType = type.isAssignableFrom(service.getClass());
            if (remove && !isType || !remove && isType) {
                resultList.add(service);
            }
            ++n2;
        }
        return resultList.toArray(new IGridService[resultList.size()]);
    }

    protected abstract IGridElement loadChild(String var1);

    protected void saveChild(IGridElement child) {
    }
}

