/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.impl.AbstractGridElement;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ContainerMarker
extends AbstractGridElement {
    private IGridContainer container;
    private MarkerType type;
    private String message;

    public ContainerMarker(IGridContainer container, MarkerType type, String message) {
        this.container = container;
        this.type = type;
        this.message = message;
    }

    public static ContainerMarker getEmptyFolderMarker(IGridContainer container) {
        return new ContainerMarker(container, MarkerType.INFO, "Folder is empty");
    }

    public static ContainerMarker getErrorMarker(IGridContainer container, Throwable t) {
        return new ContainerMarker(container, MarkerType.ERROR, t.getLocalizedMessage());
    }

    public IFileStore getFileStore() {
        return null;
    }

    public String getName() {
        return this.message;
    }

    public IGridContainer getParent() {
        return this.container;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public MarkerType getType() {
        return this.type;
    }

    public boolean isLocal() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MarkerType {
        INFO,
        ERROR;

    }
}

