/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.core.model.impl.GenericVoProperties;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.filesystem.IFileStore;

public class GenericVirtualOrganization
extends AbstractVirtualOrganization {
    private static final String VO_TYPE_NAME = "Generic VO";
    private String name;

    GenericVirtualOrganization(GenericVoCreator creator) {
        try {
            this.apply(creator);
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    GenericVirtualOrganization(IFileStore fileStore) {
        this.name = fileStore.getName();
        try {
            this.load();
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    public boolean canContain(IGridElement element) {
        return super.canContain(element) || element instanceof GenericVoProperties;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof GenericVirtualOrganization) {
            GenericVirtualOrganization vo = (GenericVirtualOrganization)o;
            result = this.getName().equals(vo.getName());
        }
        return result;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getTypeName() {
        return VO_TYPE_NAME;
    }

    public boolean isLazy() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void save() throws ProblemException {
        IGridElement[] children;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (!(child instanceof IGridService)) {
                if (child instanceof IStorableElement) {
                    ((IStorableElement)child).save();
                } else {
                    this.saveChild(child);
                }
            }
            ++n2;
        }
    }

    protected void apply(GenericVoCreator creator) throws ProblemException {
        this.name = creator.getVoName();
        GenericVoProperties properties = new GenericVoProperties(this);
        this.addElement(properties);
        creator.apply(this);
    }

    protected IGridElement loadChild(String childName) {
        GenericVoProperties child = null;
        try {
            if (childName.equals(".generic_vo_properties")) {
                GenericVoProperties properties = new GenericVoProperties(this);
                properties.load();
                child = properties;
            }
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
        return child;
    }

    public String getWizardId() {
        return "eu.geclipse.ui.wizards.GenericVoWizard";
    }

    public String getId() {
        return this.getClass().getName();
    }
}

