/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class GenericVoProperties
extends AbstractGridElement
implements IStorableElement {
    public static final String NAME = ".generic_vo_properties";
    private static final String FIELD_SEPARATOR = " ";
    private GenericVirtualOrganization vo;

    GenericVoProperties(GenericVirtualOrganization vo) {
        this.vo = vo;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getName() {
        return NAME;
    }

    public IGridContainer getParent() {
        return this.vo;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public void load() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        try {
            String line;
            InputStream iStream = fileStore.openInputStream(0, null);
            InputStreamReader isReader = new InputStreamReader(iStream);
            BufferedReader bReader = new BufferedReader(isReader);
            while ((line = bReader.readLine()) != null) {
                String[] parts = line.split(FIELD_SEPARATOR);
                if (parts.length != 2) continue;
                String serviceType = parts[0];
                URI serviceURI = new URI(parts[1]);
                IGridElementCreator creator = GridModel.getCreatorRegistry().getCreator((Object)serviceURI, serviceType);
                if (creator == null) continue;
                this.vo.create(creator);
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.core");
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.core");
        }
        catch (URISyntaxException uriExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)uriExc, "eu.geclipse.core");
        }
    }

    public void save() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        IGridElement[] children = this.vo.getChildren(null);
        try {
            OutputStream oStream = fileStore.openOutputStream(0, null);
            OutputStreamWriter osWriter = new OutputStreamWriter(oStream);
            BufferedWriter bWriter = new BufferedWriter(osWriter);
            bWriter.write(this.vo.getName());
            IGridElement[] iGridElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement child = iGridElementArray[n2];
                if (child instanceof IGridService) {
                    URI uri = ((IGridService)child).getURI();
                    bWriter.newLine();
                    bWriter.write(String.valueOf(child.getClass().getName()) + FIELD_SEPARATOR);
                    bWriter.write(uri.toString());
                }
                ++n2;
            }
            bWriter.close();
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)cExc, "eu.geclipse.core");
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioExc, "eu.geclipse.core");
        }
    }
}

