/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.model.impl;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IGridResourceContainer;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;

public class GridModelPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_GRID_CONNECTION = "isGridConnection";
    private static final String PROPERTY_RESOURCE_CATEGORY = "resourceCategory";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IResource) {
            result = this.testResource((IResource)receiver, property, args, expectedValue);
        } else if (receiver instanceof IGridElement) {
            result = this.testGridElement((IGridElement)receiver, property, args, expectedValue);
        }
        return result;
    }

    private boolean testResource(IResource resource, String property, Object[] args, Object expectedValue) {
        IGridElement element;
        boolean result = false;
        if (PROPERTY_IS_GRID_CONNECTION.equals(property) && (element = GridModel.getRoot().findElement(resource)) != null && element instanceof IGridConnection) {
            result = true;
        }
        return result;
    }

    private boolean testGridElement(IGridElement element, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (PROPERTY_RESOURCE_CATEGORY.equals(property) && element instanceof IGridResourceContainer) {
            String categoryID = expectedValue.toString();
            IGridResourceCategory referenceCategory = GridResourceCategoryFactory.getCategory(categoryID);
            IGridResourceCategory elementCategory = ((IGridResourceContainer)element).getCategory();
            result = referenceCategory != null && elementCategory.equals(referenceCategory);
        }
        return result;
    }
}

