/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.project;

import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.project.GridProjectNature;
import eu.geclipse.core.project.GridProjectProperties;
import eu.geclipse.core.project.Messages;
import eu.geclipse.core.reporting.ProblemException;
import java.util.Hashtable;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class GridProjectCreationOperation {
    private GridProjectProperties properties;
    private IProject gridProject;

    public GridProjectCreationOperation(GridProjectProperties properties) {
        this.properties = properties;
        this.gridProject = null;
    }

    public void run(IProgressMonitor monitor) throws ProblemException {
        monitor.beginTask(Messages.getString("GridProjectCreationOperation.create_progress"), 300);
        try {
            try {
                IProject proj = this.createProject(this.properties, monitor);
                this.addProjectNature(proj, monitor);
                this.gridProject = proj;
            }
            catch (CoreException cExc) {
                throw new ProblemException(cExc.getStatus());
            }
        }
        finally {
            monitor.done();
        }
    }

    public IProject getProject() {
        return this.gridProject;
    }

    private IProject createProject(GridProjectProperties props, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.getString("GridProjectCreationOperation.init_progress"));
        String projectName = props.getProjectName();
        IPath projectPath = props.getProjectLocation();
        IProject[] referencesProjects = props.getReferencesProjects();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        IStatus status = ResourcesPlugin.getWorkspace().validateProjectLocation(project, projectPath);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        IProjectDescription desc = project.getWorkspace().newProjectDescription(projectName);
        desc.setLocation(projectPath);
        if (referencesProjects != null) {
            desc.setReferencedProjects(referencesProjects);
        }
        project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        this.createProjectStructure(project, props);
        this.setProjectProperties(project, props);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return project;
    }

    private void addProjectNature(IProject proj, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.getString("GridProjectCreationOperation.add_nature_progress"));
        IProjectDescription desc = proj.getDescription();
        String[] natureIDs = desc.getNatureIds();
        String gridNatureID = GridProjectNature.getID();
        boolean found = false;
        int i = 0;
        while (i < natureIDs.length && !found) {
            if (natureIDs[i].equals(gridNatureID)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            String[] newNatureIDs = new String[natureIDs.length + 1];
            System.arraycopy(natureIDs, 0, newNatureIDs, 1, natureIDs.length);
            newNatureIDs[0] = gridNatureID;
            desc.setNatureIds(newNatureIDs);
            proj.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void createProjectFolder(IProject project, String name) throws CoreException {
        IFolder folder;
        if (name != null && name.length() != 0 && !(folder = project.getFolder((IPath)new Path(name))).exists()) {
            folder.create(1, true, null);
        }
    }

    private void createProjectStructure(IProject project, GridProjectProperties props) throws CoreException {
        Hashtable<String, String> projectFolders = props.getProjectFolders();
        for (String label : projectFolders.values()) {
            this.createProjectFolder(project, label);
        }
    }

    private void setProjectProperties(IProject project, GridProjectProperties props) throws CoreException {
        IVirtualOrganization projectVo = props.getProjectVo();
        String voName = projectVo.getName();
        Hashtable<String, String> folders = props.getProjectFolders();
        ProjectScope projectScope = new ProjectScope(project);
        try {
            IEclipsePreferences projectNode = projectScope.getNode("eu.geclipse.core");
            projectNode.put("vo", voName);
            projectNode.flush();
            IEclipsePreferences folderNode = projectScope.getNode("eu.geclipse.core.folders");
            for (String id : folders.keySet()) {
                String label = folders.get(id);
                folderNode.put(id, label);
            }
            folderNode.flush();
        }
        catch (BackingStoreException bsExc) {
            Status status = new Status(4, "eu.geclipse.core", 8, Messages.getString("GridProjectCreationOperation.preference_failure"), (Throwable)bsExc);
            throw new CoreException((IStatus)status);
        }
    }
}

