/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import java.io.ByteArrayOutputStream;

public class Base64 {
    private static final byte[] DEFAULT_ENCODING_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte DEFAULT_FILL_BYTE = 61;
    private byte[] encodingTable;
    private byte[] decodingTable;
    private byte fillbyte;

    public Base64() {
        this.setEncodingTable(DEFAULT_ENCODING_TABLE, true);
        this.setFillByte((byte)61);
    }

    public String decode(String encoded) {
        return new String(this.decode(encoded.getBytes()));
    }

    public byte[] decode(byte[] encoded) {
        int encodedLength = encoded.length;
        while (encoded[encodedLength - 1] == this.fillbyte && encodedLength > 0) {
            --encodedLength;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < encodedLength) {
            byte e1 = this.decodingTable[encoded[i]];
            int e2 = i + 1 < encodedLength ? this.decodingTable[encoded[i + 1]] : -1;
            int e3 = i + 2 < encodedLength ? this.decodingTable[encoded[i + 2]] : -1;
            int e4 = i + 3 < encodedLength ? this.decodingTable[encoded[i + 3]] : -1;
            byte d1 = (byte)(e1 << 2 & 0xFF);
            int d2 = -1;
            int d3 = -1;
            if (e2 >= 0) {
                d1 = (byte)(d1 | e2 >>> 4 & 0xFF);
                d2 = (byte)(e2 << 4 & 0xFF);
            }
            if (e3 >= 0) {
                d2 = (byte)(d2 | (byte)(e3 >>> 2 & 0xFF));
                d3 = (byte)(e3 << 6 & 0xFF);
            }
            if (e4 >= 0) {
                d3 = (byte)(d3 | (byte)(e4 & 0xFF));
            }
            out.write(d1);
            if (e2 >= 0) {
                out.write(d2);
            }
            if (e3 >= 0) {
                out.write(d3);
            }
            i += 4;
        }
        return out.toByteArray();
    }

    public String encode(String decoded) {
        return new String(this.encode(decoded.getBytes()));
    }

    public byte[] encode(byte[] decoded) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < decoded.length) {
            byte d1 = decoded[i];
            byte d2 = i + 1 < decoded.length ? decoded[i + 1] : (byte)0;
            byte d3 = i + 2 < decoded.length ? decoded[i + 2] : (byte)0;
            int i1 = d1 >>> 2 & 0x3F;
            int i2 = d1 << 4 & 0x3F;
            int i3 = -1;
            int i4 = -1;
            if (i + 1 < decoded.length) {
                i2 |= d2 >>> 4 & 0xF;
                i3 = d2 << 2 & 0x3F;
            }
            if (i + 2 < decoded.length) {
                i3 |= d3 >>> 6 & 3;
                i4 = d3 & 0x3F;
            }
            out.write(this.encodingTable[i1]);
            out.write(this.encodingTable[i2]);
            out.write(i3 >= 0 ? this.encodingTable[i3] : this.fillbyte);
            out.write(i4 >= 0 ? this.encodingTable[i4] : this.fillbyte);
            i += 3;
        }
        return out.toByteArray();
    }

    public void setDecodingTable(byte[] table) {
        this.decodingTable = new byte[table.length];
        this.encodingTable = new byte[table.length];
        int i = 0;
        while (i < table.length) {
            this.decodingTable[i] = table[i];
            ++i;
        }
    }

    public void setEncodingTable(byte[] table, boolean changeDecoding) {
        this.encodingTable = new byte[table.length];
        int i = 0;
        while (i < this.encodingTable.length) {
            this.encodingTable[i] = table[i];
            ++i;
        }
        if (changeDecoding) {
            this.decodingTable = new byte[128];
            i = 0;
            while (i < this.decodingTable.length) {
                this.decodingTable[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.encodingTable.length) {
                this.decodingTable[this.encodingTable[i]] = (byte)i;
                ++i;
            }
        }
    }

    public void setFillByte(byte b) {
        this.fillbyte = b;
    }
}

