/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.ISecurityManagerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSecurityManager
implements ISecurityManager {
    private List<ISecurityManagerListener> listeners;

    public void addListener(ISecurityManagerListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISecurityManagerListener>();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(ISecurityManagerListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireContentChanged() {
        if (this.listeners != null) {
            for (ISecurityManagerListener l : this.listeners) {
                l.contentChanged(this);
            }
        }
    }
}

