/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.core.security.X509Util;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class GildaCertificateLoader
implements ICertificateLoader {
    private static final String CA_DIR = "getCA.php";
    private static final String GILDA_CERT_ID = "gildacert";

    public X509Certificate fetchCertificate(ICertificateLoader.CertificateID id, IProgressMonitor monitor) throws ProblemException {
        return (X509Certificate)id.getData(GILDA_CERT_ID);
    }

    public ICertificateLoader.CertificateID[] listAvailableCertificates(URI uri, IProgressMonitor monitor) throws ProblemException {
        ICertificateLoader.CertificateID[] result = new ICertificateLoader.CertificateID[]{};
        Path rootPath = new Path(uri.getPath());
        String path = rootPath.append(CA_DIR).toString();
        try {
            URI newURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
            String data = String.valueOf(URLEncoder.encode("CAformat", "UTF-8")) + "=" + URLEncoder.encode("PEM", "UTF-8") + "&" + URLEncoder.encode("submit", "UTF-8") + "=" + URLEncoder.encode("submit", "UTF-8");
            URLConnection connection = Preferences.getURLConnection(newURI.toURL());
            connection.setDoOutput(true);
            OutputStreamWriter osWriter = new OutputStreamWriter(connection.getOutputStream());
            osWriter.write(data);
            osWriter.flush();
            X509Certificate cert = X509Util.loadCertificate(connection.getInputStream());
            String name = cert.getSubjectDN().getName();
            ICertificateLoader.CertificateID id = new ICertificateLoader.CertificateID(uri, name);
            id.setData(GILDA_CERT_ID, cert);
            result = new ICertificateLoader.CertificateID[]{id};
        }
        catch (URISyntaxException uriExc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)uriExc, "eu.geclipse.core");
        }
        catch (UnsupportedEncodingException ueExc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)ueExc, "eu.geclipse.core");
        }
        catch (MalformedURLException murlExc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)murlExc, "eu.geclipse.core");
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)ioExc, "eu.geclipse.core");
        }
        return result;
    }
}

