/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.internal.security.CertificateManager;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateLoader;
import eu.geclipse.core.security.Messages;
import eu.geclipse.core.security.X509Util;
import eu.geclipse.core.util.tar.TarEntry;
import eu.geclipse.core.util.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GridPMACertificateLoader
implements ICertificateLoader {
    private static final String TGZ_PREFIX = ".tgz";
    private static final String TAR_GZ_PREFIX = ".tar.gz";

    public X509Certificate fetchCertificate(ICertificateLoader.CertificateID id, IProgressMonitor monitor) throws ProblemException {
        IProgressMonitor lMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        lMonitor.beginTask(String.format(Messages.getString("GridPMACertificateLoader.loading_cert_progress"), id.getName()), 2);
        X509Certificate result = null;
        try {
            try {
                TarEntry tEntry;
                lMonitor.subTask(Messages.getString("GridPMACertificateLoader.contact_server_progress"));
                URL url = id.getURI().toURL();
                URLConnection connection = Preferences.getURLConnection(url);
                try {
                    connection.connect();
                }
                catch (SocketTimeoutException toExc) {
                    throw new ProblemException("eu.geclipse.core.problem.net.connectionTimeout", (Throwable)toExc, "eu.geclipse.core");
                }
                lMonitor.worked(1);
                lMonitor.subTask(Messages.getString("GridPMACertificateLoader.decompressing_progress"));
                InputStream iStream = connection.getInputStream();
                BufferedInputStream bStream = new BufferedInputStream(iStream);
                GZIPInputStream zStream = new GZIPInputStream(bStream);
                TarInputStream tiStream = new TarInputStream(zStream);
                while ((tEntry = tiStream.getNextEntry()) != null) {
                    IPath oPath;
                    if (tEntry.isDirectory() || !CertificateManager.CERT_FILE_PATTERN.matcher((oPath = tEntry.getPath()).lastSegment()).matches()) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    tiStream.copyEntryContents(baos);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    result = X509Util.loadCertificate(bais);
                    break;
                }
                lMonitor.worked(1);
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)ioExc, "eu.geclipse.core");
            }
        }
        finally {
            lMonitor.done();
        }
        return result;
    }

    public ICertificateLoader.CertificateID[] listAvailableCertificates(URI uri, IProgressMonitor monitor) throws ProblemException {
        ArrayList<ICertificateLoader.CertificateID> result = new ArrayList<ICertificateLoader.CertificateID>();
        IProgressMonitor lMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        lMonitor.beginTask(Messages.getString("GridPMACertificateLoader.loading_certs_progress"), 3);
        try {
            try {
                String line;
                lMonitor.subTask(Messages.getString("GridPMACertificateLoader.contact_server_progress"));
                URLConnection connection = Preferences.getURLConnection(uri.toURL());
                try {
                    connection.connect();
                }
                catch (SocketTimeoutException toExc) {
                    throw new ProblemException("eu.geclipse.core.problem.net.connectionTimeout", (Throwable)toExc, "eu.geclipse.core");
                }
                lMonitor.worked(1);
                lMonitor.subTask(Messages.getString("GridPMACertificateLoader.loading_cert_list_progress"));
                InputStream iStream = connection.getInputStream();
                InputStreamReader iReader = new InputStreamReader(iStream);
                BufferedReader bReader = new BufferedReader(iReader);
                StringBuffer buffer = new StringBuffer();
                while ((line = bReader.readLine()) != null) {
                    buffer.append(line);
                }
                bReader.close();
                lMonitor.worked(1);
                lMonitor.subTask(Messages.getString("GridPMACertificateLoader.parsing_cert_list_progress"));
                String content = buffer.toString().replaceAll(" ", "");
                int index = -1;
                while ((index = content.indexOf("ahref=\"", index + 1)) > 0) {
                    String file;
                    int endIndex = content.indexOf("\">", index + 7);
                    if (endIndex > 0 && ((file = content.substring(index + 7, endIndex)).toLowerCase().endsWith(TAR_GZ_PREFIX) || file.toLowerCase().endsWith(TGZ_PREFIX))) {
                        result.add(new ICertificateLoader.CertificateID(uri, file));
                    }
                    index = endIndex;
                }
                lMonitor.worked(1);
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)ioExc, "eu.geclipse.core");
            }
        }
        finally {
            lMonitor.done();
        }
        return result.toArray(new ICertificateLoader.CertificateID[result.size()]);
    }
}

