/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.internal.Activator;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public interface ICertificateLoader {
    public X509Certificate fetchCertificate(CertificateID var1, IProgressMonitor var2) throws ProblemException;

    public CertificateID[] listAvailableCertificates(URI var1, IProgressMonitor var2) throws ProblemException;

    public static class CertificateID {
        private URI dir;
        private String name;
        private Hashtable<String, Object> dataCache;

        protected CertificateID(URI dir, String name) {
            this.dir = dir;
            this.name = name;
        }

        public URI getDirectory() {
            return this.dir;
        }

        public String getName() {
            return this.name;
        }

        public URI getURI() {
            URI result = null;
            Path path = new Path(this.dir.getPath());
            path = path.append(this.name);
            try {
                result = new URI(this.dir.getScheme(), this.dir.getUserInfo(), this.dir.getHost(), this.dir.getPort(), path.toString(), this.dir.getQuery(), this.dir.getFragment());
            }
            catch (URISyntaxException uriExc) {
                Activator.logException(uriExc);
            }
            return result;
        }

        protected Object getData(String key) {
            Object result = null;
            if (this.dataCache != null) {
                result = this.dataCache.get(key);
            }
            return result;
        }

        protected void setData(String key, Object data) {
            if (this.dataCache == null) {
                this.dataCache = new Hashtable();
            }
            this.dataCache.put(key, data);
        }
    }
}

