/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ICertificateHandle;
import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.Messages;
import java.security.cert.X509Certificate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ICertificateManager
extends ISecurityManager {
    public ICertificateHandle addCertificate(X509Certificate var1, CertTrust var2) throws ProblemException;

    public ICertificateHandle[] addCertificates(X509Certificate[] var1, CertTrust var2) throws ProblemException;

    public List<ICertificateHandle> getAllCertificates();

    public List<ICertificateHandle> getTrustedCertificates();

    public List<ICertificateHandle> getUntrustedCertificates();

    public void removeCertificate(ICertificateHandle var1);

    public void removeCertificates(ICertificateHandle[] var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertTrust {
        Untrusted,
        Trusted,
        AlwaysTrusted;


        public boolean isTrusted() {
            return this.equals((Object)Trusted) || this.equals((Object)AlwaysTrusted);
        }

        public String toString() {
            String result = super.toString();
            if (this.equals((Object)Untrusted)) {
                result = Messages.getString("ICertificateManager.cert_trust_untrusted");
            } else if (this.equals((Object)Trusted)) {
                result = Messages.getString("ICertificateManager.cert_trust_trusted");
            } else if (this.equals((Object)AlwaysTrusted)) {
                result = Messages.getString("ICertificateManager.cert_trust_alwaystrusted");
            }
            return result;
        }
    }
}

