/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util;

import eu.geclipse.core.Messages;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.reporting.ReportingPlugin;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class TimeChecker {
    static final String[] SERVERS = new String[]{"time.fu-berlin.de", "time.mtu.edu", "ntp0.csx.cam.ac.uk"};
    private static final int RDATE_PORT = 37;
    private static final long EPOCH_DIFFERENCE = 2208988800L;
    private static final int TIMEOUT = 5000;
    private static final int MAX_SYSTIME_OFFSET = 90;
    private static final int MAX_SERVER_SPREAD = 10;
    private long sysTime = 0L;
    private long referenceTime = 0L;

    public boolean getTimeCheckStatus() {
        boolean result = false;
        if (this.sysTime != 0L && Math.abs(this.sysTime - this.referenceTime) <= 90L) {
            result = true;
        }
        return result;
    }

    public void checkSysTime(IProgressMonitor monitor) throws ProblemException, InterruptedException {
        long[] time = new long[SERVERS.length];
        long mean = 0L;
        long disp = 0L;
        ProblemException problemExc = null;
        this.sysTime = System.currentTimeMillis() / 1000L;
        monitor.beginTask(Messages.getString("TimeChecker.quering_time_servers"), SERVERS.length);
        int i = 0;
        while (i < SERVERS.length) {
            monitor.subTask(String.valueOf(Messages.getString("TimeChecker.contacting")) + " " + SERVERS[i] + "...");
            try {
                time[i] = TimeChecker.queryTime(SERVERS[i]);
            }
            catch (ProblemException pe) {
                time[i] = 0L;
                problemExc = pe;
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        Arrays.sort(time);
        monitor.done();
        int i_min = 0;
        int i2 = 0;
        while (i2 < SERVERS.length) {
            if (time[i2] == 0L) {
                i_min = (short)(i_min + 1);
            } else {
                mean += time[i2];
            }
            ++i2;
        }
        if (i_min == SERVERS.length) {
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.sys.systemTimeCheckFailed", null, problemExc, "eu.geclipse.core");
            problem.addReason(Messages.getString("TimeChecker.no_servers_reachable"));
            ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
            problem.addSolution(solution);
            solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkFirewall", null);
            problem.addSolution(solution);
            throw new ProblemException(problem);
        }
        this.referenceTime = mean /= (long)(SERVERS.length - i_min);
        disp = time[SERVERS.length - 1] - time[i_min];
        if (disp >= 10L) {
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.sys.systemTimeCheckFailed", null, (Throwable)problemExc, "eu.geclipse.core");
            problem.addReason(Messages.getString("TimeChecker.inconsistent_servers"));
            ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.contactServerAdmin", null);
            problem.addSolution(solution);
            throw new ProblemException(problem);
        }
    }

    protected static long queryTime(String serverHostname) throws ProblemException {
        DatagramSocket s;
        InetAddress addr;
        long time = 0L;
        try {
            addr = InetAddress.getByName(serverHostname);
        }
        catch (UnknownHostException uhe) {
            throw new ProblemException("eu.geclipse.core.problem.net.unknownHost", (Throwable)uhe, "eu.geclipse.core");
        }
        try {
            s = new DatagramSocket();
            s.setSoTimeout(5000);
        }
        catch (SocketException se) {
            throw new ProblemException("eu.geclipse.core.problem.net.bindFailed", (Throwable)se, "eu.geclipse.core");
        }
        DatagramPacket p = new DatagramPacket(new byte[0], 0, addr, 37);
        try {
            s.send(p);
        }
        catch (Exception exc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionFailed", (Throwable)exc, "eu.geclipse.core");
        }
        byte[] b = new byte[4];
        p = new DatagramPacket(b, b.length);
        try {
            s.receive(p);
        }
        catch (Exception exc) {
            throw new ProblemException("eu.geclipse.core.problem.net.connectionTimeout", (Throwable)exc, "eu.geclipse.core");
        }
        time = TimeChecker.readLongFromNetwork(b);
        return time - 2208988800L;
    }

    private static long readLongFromNetwork(byte[] array) {
        long unsigned = 0L;
        long val = 0L;
        int i = 0;
        while (i < array.length) {
            val <<= 8;
            unsigned = 0xFFL & (long)array[i];
            val |= unsigned;
            ++i;
        }
        return val;
    }

    public String getSystemDate() {
        Date date = new Date(this.sysTime * 1000L);
        DateFormat df = DateFormat.getDateTimeInstance(2, 0);
        return df.format(date);
    }

    public String getReferenceDate() {
        Date date = new Date(this.referenceTime * 1000L);
        DateFormat df = DateFormat.getDateTimeInstance(2, 0);
        return df.format(date);
    }

    public long getOffset() {
        return Math.abs(this.sysTime - this.referenceTime);
    }

    public int getTolerance() {
        return 90;
    }
}

