/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.model;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.info.InfoCacheListenerHandler;
import eu.geclipse.info.InfoServiceFactory;
import eu.geclipse.info.glue.GlueIndex;
import eu.geclipse.info.internal.Activator;
import eu.geclipse.info.model.IExtendedGridInfoService;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchJob
extends Job {
    private static FetchJob instance = null;

    private FetchJob(String name) {
        super(name);
    }

    public static FetchJob getInstance(String name) {
        if (instance == null) {
            instance = new FetchJob(name);
        }
        return instance;
    }

    protected IStatus run(IProgressMonitor monitor) {
        GlueIndex.drop();
        GlueIndex.getInstance();
        IProgressMonitor localMonitor = monitor != null ? monitor : new NullProgressMonitor();
        ArrayList<IGridInfoService> infoServicesArray = null;
        InfoServiceFactory myInfoServiceFactory = new InfoServiceFactory();
        infoServicesArray = myInfoServiceFactory.getAllExistingInfoService();
        int gridProjectNumbers = 0;
        try {
            IGridElement[] projectElements = GridModel.getRoot().getChildren(null);
            int i = 0;
            while (projectElements != null && i < projectElements.length) {
                IGridProject igp = (IGridProject)projectElements[i];
                if (igp != null && !igp.isHidden() && igp.getVO() != null) {
                    ++gridProjectNumbers;
                }
                ++i;
            }
        }
        catch (ProblemException e) {
            Activator.logException((Exception)((Object)e));
        }
        localMonitor.beginTask("Retrieving information", gridProjectNumbers * 10);
        int i = 0;
        while (infoServicesArray != null && !localMonitor.isCanceled() && i < infoServicesArray.size()) {
            IExtendedGridInfoService infoService;
            if (infoServicesArray.get(i) instanceof IExtendedGridInfoService && (infoService = (IExtendedGridInfoService)infoServicesArray.get(i)) != null) {
                infoService.scheduleFetch(localMonitor);
            }
            ++i;
        }
        InfoCacheListenerHandler.getInstance().notifyListeners();
        localMonitor.done();
        Status status = new Status(0, "eu.geclipse.glite.info", "Information data fetched successfully.");
        return status;
    }
}

