/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.adapters.jsdl;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.model.base.ApplicationType;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.ExactType;
import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JobIdentificationType;
import eu.geclipse.jsdl.model.base.RangeType;
import eu.geclipse.jsdl.model.base.RangeValueType;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.model.functions.ExceptionType;
import eu.geclipse.jsdl.model.functions.FunctionsFactory;
import eu.geclipse.jsdl.model.functions.FunctionsPackage;
import eu.geclipse.jsdl.model.functions.LoopType;
import eu.geclipse.jsdl.model.functions.ValuesType;
import eu.geclipse.jsdl.model.functions.impl.FunctionsPackageImpl;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import eu.geclipse.jsdl.model.sweep.AssignmentType;
import eu.geclipse.jsdl.model.sweep.SweepFactory;
import eu.geclipse.jsdl.model.sweep.SweepPackage;
import eu.geclipse.jsdl.model.sweep.SweepType;
import eu.geclipse.jsdl.model.sweep.impl.SweepPackageImpl;
import eu.geclipse.jsdl.ui.adapters.jsdl.JsdlAdaptersFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricJobAdapter
extends JsdlAdaptersFactory {
    private JobDescriptionType jobDescriptionType;
    private boolean isNotifyAllowed;
    private boolean adapterRefreshed;
    private final JSDLJobDescription JSDLJobDescr;

    public ParametricJobAdapter(JobDefinitionType jobDefinitionRoot, JSDLJobDescription jobDescr) {
        this.getTypeForAdapter(jobDefinitionRoot);
        this.JSDLJobDescr = jobDescr;
    }

    protected void contentChanged() {
        if (this.isNotifyAllowed) {
            this.fireNotifyChanged(null);
        }
    }

    private void getTypeForAdapter(JobDefinitionType jobDefinitionRoot) {
        this.jobDescriptionType = jobDefinitionRoot.getJobDescription();
    }

    public void setContent(JobDefinitionType jobDefinitionRoot) {
        this.adapterRefreshed = true;
        this.getTypeForAdapter(jobDefinitionRoot);
    }

    public List<String> getElementsList() {
        EList dataStagingList;
        ApplicationType application;
        ArrayList<String> result = new ArrayList<String>();
        JobIdentificationType jobIdentification = this.jobDescriptionType.getJobIdentification();
        if (jobIdentification != null) {
            int i;
            if (jobIdentification.getJobName() != null) {
                result.add("/*//jsdl:JobName");
            }
            if (jobIdentification.getDescription() != null) {
                result.add("/*//jsdl:JobIdentification/jsdl:Description");
            }
            if (jobIdentification.getJobAnnotation() != null) {
                int annotationsCount = jobIdentification.getJobAnnotation().size();
                if (annotationsCount > 1) {
                    i = 0;
                    while (i < annotationsCount) {
                        result.add("/*//jsdl:JobAnnotation[" + (i + 1) + "]");
                        ++i;
                    }
                } else if (annotationsCount == 1) {
                    result.add("/*//jsdl:JobAnnotation");
                }
            }
            if (jobIdentification.getJobProject() != null) {
                int projectCount = jobIdentification.getJobProject().size();
                if (projectCount > 1) {
                    i = 0;
                    while (i < projectCount) {
                        result.add("/*//jsdl:JobProject[" + (i + 1) + "]");
                        ++i;
                    }
                } else if (projectCount == 1) {
                    result.add("/*//jsdl:JobProject");
                }
            }
        }
        if ((application = this.jobDescriptionType.getApplication()) != null) {
            if (application.getApplicationName() != null) {
                result.add("/*//jsdl:ApplicationName");
            }
            if (application.getApplicationVersion() != null) {
                result.add("/*//jsdl:ApplicationVersion");
            }
            if (application.getDescription() != null) {
                result.add("/*//jsdl:Application/jsdl:Description");
            }
            FeatureMap map = application.getAny();
            int i = 0;
            while (i < map.size()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)map.get(i);
                if (entry.getValue() instanceof POSIXApplicationType) {
                    int j;
                    POSIXApplicationType posixApp = (POSIXApplicationType)entry.getValue();
                    if (posixApp.getArgument() != null) {
                        int argumentsCount = posixApp.getArgument().size();
                        if (argumentsCount > 1) {
                            j = 0;
                            while (j < argumentsCount) {
                                result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Argument[" + (j + 1) + "]");
                                ++j;
                            }
                        } else if (argumentsCount == 1) {
                            result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Argument");
                        }
                    }
                    if (posixApp.getExecutable() != null) {
                        result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Executable");
                    }
                    if (posixApp.getInput() != null) {
                        result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Input");
                    }
                    if (posixApp.getOutput() != null) {
                        result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Output");
                    }
                    if (posixApp.getError() != null) {
                        result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Error");
                    }
                    if (posixApp.getEnvironment() != null) {
                        int envCount = posixApp.getEnvironment().size();
                        if (envCount > 1) {
                            j = 0;
                            while (j < envCount) {
                                result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Environment[" + (j + 1) + "]");
                                ++j;
                            }
                        } else if (envCount == 1) {
                            result.add("/*//jsdl-posix:POSIXApplication/jsdl-posix:Environment");
                        }
                    }
                }
                ++i;
            }
        }
        if ((dataStagingList = this.jobDescriptionType.getDataStaging()) != null) {
            int dataStagingCount = dataStagingList.size();
            if (dataStagingCount > 1) {
                int i = 1;
                for (DataStagingType dataStaging : dataStagingList) {
                    result.addAll(this.parseDataStagingElement(dataStaging, "/*//jsdl:DataStaging[" + i + "]"));
                    ++i;
                }
            } else if (dataStagingCount == 1) {
                DataStagingType data = (DataStagingType)dataStagingList.get(0);
                result.addAll(this.parseDataStagingElement(data, "/*//jsdl:DataStaging"));
            }
        }
        if (this.jobDescriptionType.getResources() != null) {
            result.addAll(this.parseResources(this.jobDescriptionType.getResources()));
        }
        return result;
    }

    private List<String> parseResources(ResourcesType resources) {
        ArrayList<String> result = new ArrayList<String>();
        String baseString = "/*//jsdl:Resources/";
        if (resources.getCandidateHosts() != null) {
            String baseCandidate = String.valueOf(baseString) + "jsdl:CandidateHosts/";
            if (resources.getCandidateHosts().getHostName().size() > 1) {
                int i = 1;
                Iterator iterator = resources.getCandidateHosts().getHostName().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    result.add(String.valueOf(baseCandidate) + "jsdl:HostName[" + i + "]");
                    ++i;
                }
            } else {
                result.add(String.valueOf(baseCandidate) + "jsdl:HostName");
            }
        }
        if (resources.getFileSystem() != null) {
            if (resources.getFileSystem().size() > 1) {
                int i = 1;
                for (Object fsType : resources.getFileSystem()) {
                    String fsBase = String.valueOf(baseString) + "jsdl:FileSystem[" + i + "]";
                    this.parseFileSystem((FileSystemType)fsType, fsBase);
                    ++i;
                }
            } else {
                String fsBase = String.valueOf(baseString) + "jsdl:FileSystem";
                if (resources.getFileSystem().size() != 0) {
                    this.parseFileSystem((FileSystemType)resources.getFileSystem().get(0), fsBase);
                }
            }
        }
        if (resources.isSetExclusiveExecution()) {
            result.add(String.valueOf(baseString) + "jsdl:ExclusiveExecution");
        }
        if (resources.getOperatingSystem() != null) {
            String baseOS = String.valueOf(baseString) + "jsdl:OperatingSystem/";
            if (resources.getOperatingSystem().getOperatingSystemType() != null) {
                result.add(String.valueOf(baseOS) + "jsdl:OperatingSystemType/jsdl:OperatingStystemName");
            }
            if (resources.getOperatingSystem().getOperatingSystemVersion() != null) {
                result.add(String.valueOf(baseOS) + "jsdl:OperatingSystemVersion");
            }
            if (resources.getOperatingSystem().getDescription() != null) {
                result.add(String.valueOf(baseOS) + "jsdl:Description");
            }
            if (resources.getCPUArchitecture() != null) {
                result.add(String.valueOf(baseString) + "jsdl:CPUArchitecture/jsdl:CPUArchitectureName");
            }
        }
        result.addAll(this.parseRangeValueType(resources.getIndividualCPUSpeed(), String.valueOf(baseString) + "jsdl:IndividualCPUSpeed/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualCPUTime(), String.valueOf(baseString) + "jsdl:IndividualCPUTime/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualCPUCount(), String.valueOf(baseString) + "jsdl:IndividualCPUCount/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualNetworkBandwidth(), String.valueOf(baseString) + "jsdl:IndividualNetworkBandwidth/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualPhysicalMemory(), String.valueOf(baseString) + "jsdl:IndividualPhysicalMemory/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualVirtualMemory(), String.valueOf(baseString) + "jsdl:IndividualVirtualMemory/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualCPUTime(), String.valueOf(baseString) + "jsdl:IndividualCPUTime/"));
        result.addAll(this.parseRangeValueType(resources.getIndividualDiskSpace(), String.valueOf(baseString) + "jsdl:IndividualDiskSpace/"));
        result.addAll(this.parseRangeValueType(resources.getTotalCPUTime(), String.valueOf(baseString) + "jsdl:TotalCPUTime/"));
        result.addAll(this.parseRangeValueType(resources.getTotalCPUCount(), String.valueOf(baseString) + "jsdl:TotalCPUCount/"));
        result.addAll(this.parseRangeValueType(resources.getTotalPhysicalMemory(), String.valueOf(baseString) + "jsdl:TotalPhysicalMemory/"));
        result.addAll(this.parseRangeValueType(resources.getTotalVirtualMemory(), String.valueOf(baseString) + "jsdl:TotalVirtualMemory/"));
        result.addAll(this.parseRangeValueType(resources.getTotalDiskSpace(), String.valueOf(baseString) + "jsdl:TotalDiskSpace/"));
        result.addAll(this.parseRangeValueType(resources.getTotalResourceCount(), String.valueOf(baseString) + "jsdl:TotalResourceCount/"));
        return result;
    }

    private List<String> parseFileSystem(FileSystemType fileSystem, String fsString) {
        ArrayList<String> result = new ArrayList<String>();
        if (fileSystem.getDescription() != null) {
            result.add(String.valueOf(fsString) + "/jsdl:Description");
        }
        if (fileSystem.getMountPoint() != null) {
            result.add(String.valueOf(fsString) + "/jsdl:MountPoint");
        }
        if (fileSystem.getDiskSpace() != null) {
            result.addAll(this.parseRangeValueType(fileSystem.getDiskSpace(), String.valueOf(fsString) + "/jsdl:DiskSpace/"));
        }
        if (fileSystem.getFileSystemType() != null) {
            result.add(String.valueOf(fsString) + "/jsdl:FileSystemType");
        }
        if (fileSystem.getName() != null) {
            result.add(String.valueOf(fsString) + "@name");
        }
        return result;
    }

    private List<String> parseRangeValueType(RangeValueType rangeType, String baseString) {
        ArrayList<String> result = new ArrayList<String>();
        if (rangeType != null) {
            int i;
            if (rangeType.getUpperBound() != null) {
                result.add(String.valueOf(baseString) + "jsdl:UpperBoundedRange");
                if (rangeType.getUpperBound().isSetExclusiveBound()) {
                    result.add(String.valueOf(baseString) + "jsdl:UpperBoundedRange@exclusiveBound");
                }
            }
            if (rangeType.getLowerBound() != null) {
                result.add(String.valueOf(baseString) + "jsdl:UpperLowerRange");
                if (rangeType.getLowerBound().isSetExclusiveBound()) {
                    result.add(String.valueOf(baseString) + "jsdl:UpperLowerRange@exclusiveBound");
                }
            }
            if (rangeType.getExact() != null) {
                if (rangeType.getExact().size() > 1) {
                    i = 1;
                    for (Object obj : rangeType.getExact()) {
                        String baseExact = String.valueOf(baseString) + "jsdl:Exact[" + i + "]";
                        result.add(baseExact);
                        if (((ExactType)obj).isSetEpsilon()) {
                            result.add(String.valueOf(baseExact) + "@epsilon");
                        }
                        ++i;
                    }
                } else {
                    result.add(String.valueOf(baseString) + "jsdl:Exact");
                    if (((ExactType)rangeType.getExact().get(0)).isSetEpsilon()) {
                        result.add(String.valueOf(baseString) + "jsdl:Exact@epsilon");
                    }
                }
            }
            if (rangeType.getRange() != null) {
                if (rangeType.getRange().size() > 1) {
                    i = 1;
                    for (Object obj : rangeType.getRange()) {
                        result.addAll(this.parseRangeType((RangeType)obj, String.valueOf(baseString) + "jsdl:Range[" + i + "]/"));
                    }
                } else {
                    result.addAll(this.parseRangeType((RangeType)rangeType.getRange().get(0), String.valueOf(baseString) + "jsdl:Range/"));
                }
            }
        }
        return result;
    }

    private List<String> parseRangeType(RangeType range, String baseString) {
        ArrayList<String> result = new ArrayList<String>();
        if (range.getLowerBound() != null) {
            result.add(String.valueOf(baseString) + "jsdl:LowerBound");
            if (range.getLowerBound().isSetExclusiveBound()) {
                result.add(String.valueOf(baseString) + "jsdl:LowerBound@ExclusiveBound");
            }
        }
        if (range.getUpperBound() != null) {
            result.add(String.valueOf(baseString) + "jsdl:UpperBound");
            if (range.getUpperBound().isSetExclusiveBound()) {
                result.add(String.valueOf(baseString) + "jsdl:UpperBound@ExclusiveBound");
            }
        }
        return result;
    }

    private List<String> parseDataStagingElement(DataStagingType dataStaging, String baseString) {
        ArrayList<String> result = new ArrayList<String>();
        if (dataStaging.getFileName() != null && !dataStaging.getFileName().equals("")) {
            result.add(String.valueOf(baseString) + "/jsdl:FileName");
        }
        if (dataStaging.getFilesystemName() != null && !dataStaging.getFilesystemName().equals("")) {
            result.add(String.valueOf(baseString) + "/jsdl:FilesystemName");
        }
        if (dataStaging.isSetCreationFlag()) {
            result.add(String.valueOf(baseString) + "/jsdl:CreationFlag");
        }
        if (dataStaging.isSetDeleteOnTermination()) {
            result.add(String.valueOf(baseString) + "/jsdl:DeleteOnTermination");
        }
        if (dataStaging.getSource() != null && dataStaging.getSource().getURI() != null && !dataStaging.getSource().getURI().equals("")) {
            result.add(String.valueOf(baseString) + "/jsdl:Source/jsdl:URI");
        }
        if (dataStaging.getTarget() != null && dataStaging.getTarget().getURI() != null && !dataStaging.getTarget().getURI().equals("")) {
            result.add(String.valueOf(baseString) + "/jsdl:Target/jsdl:URI");
        }
        return result;
    }

    public List<String> getValuesForParameter(String paramName, List<SweepType> sweepList) {
        ArrayList<String> result = new ArrayList<String>();
        SweepType sweep = this.findSweepElement(paramName, sweepList);
        if (sweep != null) {
            AssignmentType assignment = null;
            int j = 0;
            while (j < sweep.getAssignment().size()) {
                if (((AssignmentType)sweep.getAssignment().get(j)).getParameter().contains((Object)paramName)) {
                    assignment = (AssignmentType)sweep.getAssignment().get(j);
                    break;
                }
                ++j;
            }
            if (assignment != null) {
                ValuesType values;
                if (assignment.getFunction() instanceof ValuesType && (values = (ValuesType)assignment.getFunction()) != null) {
                    int i = 0;
                    while (i < values.getValue().size()) {
                        result.add((String)values.getValue().get(i));
                        ++i;
                    }
                }
                for (Object obj : assignment.getFunctionGroup()) {
                    EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry loopF;
                    if (!(obj instanceof EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry) || !((loopF = (EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry)obj).getValue() instanceof LoopType)) continue;
                    LoopType loop = (LoopType)loopF.getValue();
                    ArrayList<BigInteger> list = new ArrayList<BigInteger>();
                    ExceptionType[] exceptionTypeArray = (ExceptionType[])loop.getException().toArray((Object[])new ExceptionType[0]);
                    int n = exceptionTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExceptionType exc = exceptionTypeArray[n2];
                        list.add(exc.getValue());
                        ++n2;
                    }
                    result.add(ParametricJobAdapter.createLOOPString(loop.getStart(), loop.getEnd(), loop.getStep(), list));
                }
            }
        }
        return result;
    }

    public SweepType findSweepElement(String name, List<SweepType> sweepList) {
        SweepType refSweep = null;
        for (SweepType sweep : sweepList) {
            EList list = sweep.getAssignment();
            int i = 0;
            while (i < list.size()) {
                Object el = list.get(i);
                if (el instanceof AssignmentType) {
                    AssignmentType assignment = (AssignmentType)el;
                    EList paramList = assignment.getParameter();
                    int j = 0;
                    while (j < paramList.size()) {
                        String name1 = (String)paramList.get(j);
                        if (name1.equals(name)) {
                            refSweep = sweep;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return refSweep;
    }

    public static String createLOOPString(BigInteger startValue, BigInteger endValue, BigInteger stepValue, List<BigInteger> exceptionsValues) {
        String result = "LOOP";
        result = String.valueOf(result) + "( start = " + startValue.toString() + "; ";
        result = String.valueOf(result) + "end = " + endValue.toString() + "; ";
        result = String.valueOf(result) + "step = " + stepValue.toString() + " )";
        if (exceptionsValues != null & exceptionsValues.size() > 0) {
            result = String.valueOf(result) + " \\ { ";
            for (BigInteger exc : exceptionsValues) {
                result = String.valueOf(result) + exc.toString() + "; ";
            }
            result = result.substring(0, result.length() - 2);
            result = String.valueOf(result) + " }";
        }
        ParametricJobAdapter.parseLOOPStringForEnd(result);
        ParametricJobAdapter.parseLOOPStringForStep(result);
        return result;
    }

    public static BigInteger parseLOOPStringForStart(String loopString) {
        BigInteger result = null;
        String[] splited = loopString.split("start\\s*=\\s*");
        if (splited.length > 1) {
            result = new BigInteger(splited[1].split("\\s*;")[0]);
        }
        return result;
    }

    public static BigInteger parseLOOPStringForEnd(String loopString) {
        BigInteger result = null;
        String[] splited = loopString.split("end\\s*=\\s*");
        if (splited.length > 1) {
            result = new BigInteger(splited[1].split("\\s*;")[0]);
        }
        return result;
    }

    public static BigInteger parseLOOPStringForStep(String loopString) {
        BigInteger result = null;
        String[] splited = loopString.split("step\\s*=\\s*");
        if (splited.length > 1) {
            result = new BigInteger(splited[1].split("\\s*\\)")[0]);
        }
        return result;
    }

    public static List<ExceptionType> parseLOOPStringForExceptions(String loopString) {
        ArrayList<ExceptionType> result = new ArrayList<ExceptionType>();
        FunctionsPackage pak = FunctionsPackageImpl.eINSTANCE;
        FunctionsFactory factory = pak.getFunctionsFactory();
        String[] splited = loopString.split("\\s*\\\\\\s*\\{\\s*");
        if (splited.length > 1) {
            String[] stringArray = splited = splited[1].split("\\s*;\\s*");
            int n = splited.length;
            int n2 = 0;
            while (n2 < n) {
                String split = stringArray[n2];
                try {
                    if (split.endsWith(" }")) {
                        split = split.split("\\s*\\}")[0];
                    }
                    ExceptionType exc = factory.createExceptionType();
                    exc.setValue(new BigInteger(split));
                    result.add(exc);
                }
                catch (NumberFormatException numberFormatException) {}
                ++n2;
            }
        }
        return result;
    }

    private void setEnumValues(AssignmentType assignment, List<String> values) {
        if (values != null && values.size() > 0) {
            FunctionsPackage pak = FunctionsPackageImpl.eINSTANCE;
            FunctionsFactory factory = pak.getFunctionsFactory();
            ValuesType valuesType = factory.createValuesType();
            for (String value : values) {
                if (value.equals("")) continue;
                valuesType.getValue().add((Object)value);
            }
            EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)pak);
            FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("values"), (Object)valuesType);
            assignment.getFunctionGroup().add((Object)e);
        } else {
            assignment.getFunctionGroup().clear();
        }
    }

    private void setLoop(AssignmentType assignment, List<String> values) {
        if (values != null && values.size() > 0) {
            FunctionsPackage pak = FunctionsPackageImpl.eINSTANCE;
            FunctionsFactory factory = pak.getFunctionsFactory();
            for (String loopExp : values) {
                LoopType loopType = factory.createLoopType();
                loopType.setStart(ParametricJobAdapter.parseLOOPStringForStart(loopExp));
                loopType.setEnd(ParametricJobAdapter.parseLOOPStringForEnd(loopExp));
                loopType.setStep(ParametricJobAdapter.parseLOOPStringForStep(loopExp));
                for (ExceptionType exc : ParametricJobAdapter.parseLOOPStringForExceptions(loopExp)) {
                    loopType.getException().add((Object)exc);
                }
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)pak);
                FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("loop"), (Object)loopType);
                assignment.getFunctionGroup().add((Object)e);
            }
        } else {
            assignment.getFunctionGroup().clear();
        }
    }

    public void setFunctionValues(AssignmentType assignment, List<String> values) {
        ArrayList<String> loops = new ArrayList<String>();
        for (String value : values) {
            if (!value.startsWith("LOOP")) continue;
            loops.add(value);
        }
        values.removeAll(loops);
        if (assignment.getFunctionGroup() != null) {
            assignment.getFunctionGroup().clear();
        }
        if (values.size() > 0) {
            this.setEnumValues(assignment, values);
        } else {
            this.setLoop(assignment, loops);
        }
    }

    public SweepType createNewSweepType(String parameter) {
        SweepType result = null;
        SweepPackage pak = SweepPackageImpl.eINSTANCE;
        SweepFactory factory = pak.getSweepFactory();
        result = factory.createSweepType();
        AssignmentType assignment = factory.createAssignmentType();
        assignment.getParameter().add((Object)parameter);
        result.getAssignment().add((Object)assignment);
        return result;
    }

    public AssignmentType createNewAssignmentType(String parameter) {
        AssignmentType result = null;
        SweepPackage pak = SweepPackageImpl.eINSTANCE;
        SweepFactory factory = pak.getSweepFactory();
        result = factory.createAssignmentType();
        result.getParameter().add((Object)parameter);
        return result;
    }

    public String getDefaultValueForParam(String paramXPath) {
        String result = "";
        Document xmlDoc = this.JSDLJobDescr.getXml();
        XPath xpathEngine = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression expression = xpathEngine.compile(paramXPath);
            expression.evaluate(xmlDoc.getFirstChild(), XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return result;
    }
}

