/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.adapters.jsdl;

import eu.geclipse.jsdl.model.base.BoundaryType;
import eu.geclipse.jsdl.model.base.CPUArchitectureType;
import eu.geclipse.jsdl.model.base.CandidateHostsType;
import eu.geclipse.jsdl.model.base.ExactType;
import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.OperatingSystemType;
import eu.geclipse.jsdl.model.base.OperatingSystemTypeEnumeration;
import eu.geclipse.jsdl.model.base.OperatingSystemTypeType;
import eu.geclipse.jsdl.model.base.ProcessorArchitectureEnumeration;
import eu.geclipse.jsdl.model.base.RangeValueType;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.ui.adapters.jsdl.JsdlAdaptersFactory;
import eu.geclipse.jsdl.ui.internal.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public final class ResourcesTypeAdapter
extends JsdlAdaptersFactory {
    protected static final String LOWER_BOUND = JsdlPackage.Literals.RANGE_VALUE_TYPE__LOWER_BOUND.getName();
    protected static final String UPPER_BOUND = JsdlPackage.Literals.RANGE_VALUE_TYPE__UPPER_BOUND.getName();
    protected static final String EXACT = JsdlPackage.Literals.RANGE_VALUE_TYPE__EXACT.getName();
    protected static final String[] RESOURCES_BOUNDARY_ITEMS = new String[]{"", LOWER_BOUND, UPPER_BOUND, EXACT};
    private static final String EMPTY_STRING = "";
    protected Hashtable<Integer, Text> widgetFeaturesMap = new Hashtable();
    protected Hashtable<Integer, TableViewer> viewerFeaturesMap = new Hashtable();
    protected Hashtable<Integer, Combo> comboFeaturesMap = new Hashtable();
    protected Hashtable<String, EStructuralFeature> eStructuralFeaturesMap = new Hashtable();
    protected JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();
    protected ResourcesType resourcesType = JsdlFactory.eINSTANCE.createResourcesType();
    protected CandidateHostsType candidateHosts = JsdlFactory.eINSTANCE.createCandidateHostsType();
    protected OperatingSystemType operatingSystemType = JsdlFactory.eINSTANCE.createOperatingSystemType();
    protected OperatingSystemTypeType operatingSystemTypeType = JsdlFactory.eINSTANCE.createOperatingSystemTypeType();
    protected FileSystemType fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
    protected CPUArchitectureType cpuArchitectureType = JsdlFactory.eINSTANCE.createCPUArchitectureType();
    protected BoundaryType boundaryType = JsdlFactory.eINSTANCE.createBoundaryType();
    protected ExactType exactType = JsdlFactory.eINSTANCE.createExactType();
    protected RangeValueType rangeValueType = JsdlFactory.eINSTANCE.createRangeValueType();
    private boolean adapterRefreshed = false;
    private boolean isNotifyAllowed = true;

    public ResourcesTypeAdapter(JobDefinitionType jobDefinitionRoot) {
        this.getTypeForAdapter(jobDefinitionRoot);
    }

    private void getTypeForAdapter(JobDefinitionType jobDefinitionRoot) {
        this.jobDescriptionType = jobDefinitionRoot.getJobDescription();
        if (this.jobDescriptionType.getResources() != null) {
            this.resourcesType = this.jobDescriptionType.getResources();
        }
    }

    public void setContent(JobDefinitionType jobDefinitionRoot) {
        this.adapterRefreshed = true;
        this.getTypeForAdapter(jobDefinitionRoot);
    }

    protected void contentChanged() {
        if (this.isNotifyAllowed) {
            this.fireNotifyChanged(null);
        }
    }

    public void attachToHostName(TableViewer widget) {
        Integer featureID = 0;
        this.viewerFeaturesMap.put(featureID, widget);
    }

    protected void deleteElement(EObject eStructuralFeature) {
        try {
            EcoreUtil.remove((EObject)eStructuralFeature);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    public void attachToFileSystems(TableViewer widget) {
        Integer featureID = 1;
        this.viewerFeaturesMap.put(featureID, widget);
    }

    public void attachToDelete(Button button, final TableViewer tableViewer) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ResourcesTypeAdapter.this.performDelete(tableViewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void addCandidateHosts(TableViewer tableViewer, Object[] value) {
        if (value == null) {
            return;
        }
        ArrayList<String> collection = new ArrayList<String>();
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i = 0;
        while (i < value.length) {
            newInputList.add((Object)((String)value[i]));
            ++i;
        }
        tableViewer.setInput((Object)newInputList);
        i = 0;
        while (i < tableViewer.getTable().getItemCount()) {
            collection.add((String)tableViewer.getElementAt(i));
            ++i;
        }
        this.checkCandidateHostsElement();
        this.candidateHosts.getHostName().clear();
        this.candidateHosts.getHostName().addAll(collection);
        this.contentChanged();
        collection = null;
    }

    public void addFileSystem(TableViewer tableViewer, Object[] value) {
        if (value == null) {
            return;
        }
        ArrayList<FileSystemType> collection = new ArrayList<FileSystemType>();
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i = 0;
        while (i < value.length) {
            newInputList.add((Object)((FileSystemType)value[i]));
            ++i;
        }
        tableViewer.setInput((Object)newInputList);
        i = 0;
        while (i < tableViewer.getTable().getItemCount()) {
            collection.add((FileSystemType)tableViewer.getElementAt(i));
            ++i;
        }
        this.checkFileSystemElement();
        this.resourcesType.getFileSystem().clear();
        this.resourcesType.getFileSystem().addAll(collection);
        this.contentChanged();
        collection = null;
    }

    public void performEdit(TableViewer tableViewer, Object value) {
        if (value == null) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            Object feature = structSelection.getFirstElement();
            int idx = this.resourcesType.getFileSystem().indexOf(feature);
            try {
                this.resourcesType.getFileSystem().set(idx, value);
            }
            catch (Exception e) {
                Activator.logException(e);
            }
            tableViewer.refresh();
            this.contentChanged();
        }
    }

    protected void checkResourcesElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(2);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.resourcesType);
        } else if (!this.resourcesType.isExclusiveExecution() && this.resourcesType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.resourcesType);
        }
    }

    protected void checkCandidateHostsElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(0);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            this.resourcesType.eSet(eStructuralFeature, (Object)this.candidateHosts);
        }
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        if (structSelection != null) {
            for (Object feature : structSelection) {
                try {
                    if (!this.adapterRefreshed) {
                        if (feature instanceof String) {
                            this.candidateHosts.getHostName().remove(feature);
                            if (this.candidateHosts.getHostName().size() == 0) {
                                EcoreUtil.remove((EObject)this.candidateHosts);
                                this.checkResourcesElement();
                            }
                        } else {
                            this.resourcesType.getFileSystem().remove(feature);
                            if (this.resourcesType.getFileSystem().size() == 0) {
                                EcoreUtil.remove((EObject)this.fileSystemType);
                                this.checkResourcesElement();
                            }
                        }
                        this.contentChanged();
                    } else {
                        viewer.remove(feature);
                    }
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                viewer.refresh();
            }
        }
    }

    protected void checkOSElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(3);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            if (this.operatingSystemType == null) {
                this.operatingSystemType = JsdlFactory.eINSTANCE.createOperatingSystemType();
            }
            this.resourcesType.eSet(eStructuralFeature, (Object)this.operatingSystemType);
        }
    }

    protected void checkFileSystemElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(1);
        ArrayList<FileSystemType> collection = new ArrayList<FileSystemType>();
        if (this.fileSystemType == null) {
            this.fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
        }
        collection.add(this.fileSystemType);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            this.resourcesType.eSet(eStructuralFeature, collection);
        }
    }

    protected void checkCPUArch() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(4);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            if (this.cpuArchitectureType == null) {
                this.cpuArchitectureType = JsdlFactory.eINSTANCE.createCPUArchitectureType();
            }
            this.resourcesType.eSet(eStructuralFeature, (Object)this.cpuArchitectureType);
        }
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.resourcesType);
        }
        return eObject;
    }

    public void attachToOSType(final Combo widget) {
        Integer featureID = 3;
        this.comboFeaturesMap.put(featureID, widget);
        EEnum cFEnum = JsdlPackage.Literals.OPERATING_SYSTEM_TYPE_ENUMERATION;
        widget.add(EMPTY_STRING);
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            widget.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        Object[] sortedTypes = widget.getItems();
        Arrays.sort(sortedTypes);
        widget.setItems((String[])sortedTypes);
        widget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedOSName = widget.getItem(widget.getSelectionIndex());
                if (selectedOSName == ResourcesTypeAdapter.EMPTY_STRING) {
                    ResourcesTypeAdapter.this.deleteElement((EObject)ResourcesTypeAdapter.this.operatingSystemType);
                    ResourcesTypeAdapter.this.operatingSystemType = null;
                } else {
                    ResourcesTypeAdapter.this.checkOSElement();
                    ResourcesTypeAdapter.this.operatingSystemTypeType.setOperatingSystemName(OperatingSystemTypeEnumeration.get((String)selectedOSName));
                    ResourcesTypeAdapter.this.operatingSystemType.setOperatingSystemType(ResourcesTypeAdapter.this.operatingSystemTypeType);
                }
                ResourcesTypeAdapter.this.contentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void attachToCPUArchitecture(final Combo widget) {
        Integer featureID = 4;
        this.comboFeaturesMap.put(featureID, widget);
        EEnum cFEnum = JsdlPackage.Literals.PROCESSOR_ARCHITECTURE_ENUMERATION;
        widget.add(EMPTY_STRING);
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            widget.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        cFEnum = null;
        Object[] sortedTypes = widget.getItems();
        Arrays.sort(sortedTypes);
        widget.setItems((String[])sortedTypes);
        widget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedCPUArch = widget.getItem(widget.getSelectionIndex());
                if (widget.getItem(widget.getSelectionIndex()) == ResourcesTypeAdapter.EMPTY_STRING) {
                    ResourcesTypeAdapter.this.deleteElement((EObject)ResourcesTypeAdapter.this.cpuArchitectureType);
                    ResourcesTypeAdapter.this.cpuArchitectureType = null;
                } else {
                    ResourcesTypeAdapter.this.checkCPUArch();
                    ResourcesTypeAdapter.this.cpuArchitectureType.setCPUArchitectureName(ProcessorArchitectureEnumeration.get((String)selectedCPUArch));
                    ResourcesTypeAdapter.this.cpuArchitectureType = (CPUArchitectureType)ResourcesTypeAdapter.this.checkProxy((EObject)ResourcesTypeAdapter.this.cpuArchitectureType);
                    ResourcesTypeAdapter.this.resourcesType.setCPUArchitecture(ResourcesTypeAdapter.this.cpuArchitectureType);
                }
                ResourcesTypeAdapter.this.contentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void attachToOSVersion(final Text widget) {
        Integer featureID = 37;
        this.widgetFeaturesMap.put(featureID, widget);
        widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcesTypeAdapter.this.checkOSElement();
                ResourcesTypeAdapter.this.operatingSystemType.setOperatingSystemVersion(widget.getText());
                ResourcesTypeAdapter.this.contentChanged();
            }
        });
    }

    public void attachToOSDescription(final Text widget) {
        Integer featureID = 12;
        this.widgetFeaturesMap.put(featureID, widget);
        widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcesTypeAdapter.this.checkOSElement();
                if (!widget.getText().equals(ResourcesTypeAdapter.EMPTY_STRING)) {
                    ResourcesTypeAdapter.this.operatingSystemType.setDescription(widget.getText());
                } else {
                    ResourcesTypeAdapter.this.operatingSystemType.setDescription(null);
                }
                ResourcesTypeAdapter.this.contentChanged();
            }
        });
    }

    public void attachToIndividualCPUSpeed(final Text text, final Combo combo) {
        Integer featureID = 21;
        this.widgetFeaturesMap.put(featureID, text);
        this.comboFeaturesMap.put(featureID, combo);
        combo.setItems(RESOURCES_BOUNDARY_ITEMS);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (combo.getItem(combo.getSelectionIndex()) == ResourcesTypeAdapter.EMPTY_STRING) {
                    ResourcesTypeAdapter.this.resourcesType.setIndividualCPUSpeed(null);
                } else if (combo.getItem(combo.getSelectionIndex()) == UPPER_BOUND) {
                    ResourcesTypeAdapter.this.boundaryType.setValue(Double.parseDouble(text.getText()));
                    ResourcesTypeAdapter.this.rangeValueType.setUpperBound(ResourcesTypeAdapter.this.boundaryType);
                    ResourcesTypeAdapter.this.resourcesType.setIndividualCPUSpeed(ResourcesTypeAdapter.this.rangeValueType);
                } else if (combo.getItem(combo.getSelectionIndex()) == LOWER_BOUND) {
                    ResourcesTypeAdapter.this.boundaryType.setValue(Double.parseDouble(text.getText()));
                    ResourcesTypeAdapter.this.rangeValueType.setLowerBound(ResourcesTypeAdapter.this.boundaryType);
                    ResourcesTypeAdapter.this.resourcesType.setIndividualCPUSpeed(ResourcesTypeAdapter.this.rangeValueType);
                } else if (combo.getItem(combo.getSelectionIndex()) == EXACT) {
                    ResourcesTypeAdapter.this.rangeValueType.setLowerBound(null);
                    ResourcesTypeAdapter.this.rangeValueType.setUpperBound(null);
                    ResourcesTypeAdapter.this.exactType.setValue(Double.parseDouble(text.getText()));
                    ResourcesTypeAdapter.this.rangeValueType.getExact().add((Object)ResourcesTypeAdapter.this.exactType);
                    ResourcesTypeAdapter.this.resourcesType.setIndividualCPUSpeed(ResourcesTypeAdapter.this.rangeValueType);
                }
                ResourcesTypeAdapter.this.contentChanged();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourcesTypeAdapter.this.checkOSElement();
                if (text.getText().equals(ResourcesTypeAdapter.EMPTY_STRING)) {
                    ResourcesTypeAdapter.this.resourcesType.setIndividualCPUSpeed(null);
                }
                ResourcesTypeAdapter.this.contentChanged();
            }
        });
    }

    public void attachToExclusiveExecution(final Combo widget) {
        Integer featureID = 2;
        this.comboFeaturesMap.put(featureID, widget);
        widget.add(EMPTY_STRING);
        widget.add("true");
        widget.add("false");
        widget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (widget.getItem(widget.getSelectionIndex()) == ResourcesTypeAdapter.EMPTY_STRING) {
                    ResourcesTypeAdapter.this.resourcesType.unsetExclusiveExecution();
                } else {
                    ResourcesTypeAdapter.this.checkResourcesElement();
                    ResourcesTypeAdapter.this.resourcesType.setExclusiveExecution(Boolean.parseBoolean(widget.getText()));
                }
                ResourcesTypeAdapter.this.contentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void load() {
        this.isNotifyAllowed = false;
        Text widgetName = null;
        TableViewer tableViewer = null;
        Combo comboName = null;
        if (this.resourcesType != null) {
            EClass eClass = this.resourcesType.eClass();
            EList eAllStructuralFeaures = eClass.getEAllStructuralFeatures();
            block10: for (EStructuralFeature eStructuralFeature : eAllStructuralFeaures) {
                int featureID = eStructuralFeature.getFeatureID();
                if (!this.resourcesType.eIsSet(eStructuralFeature)) continue;
                if (eStructuralFeature instanceof EReference) {
                    switch (featureID) {
                        case 18: {
                            break;
                        }
                        case 0: {
                            tableViewer = this.viewerFeaturesMap.get(featureID);
                            this.candidateHosts = (CandidateHostsType)this.resourcesType.eGet(eStructuralFeature);
                            EList valueEList = this.candidateHosts.getHostName();
                            tableViewer.setInput((Object)valueEList);
                            break;
                        }
                        case 3: {
                            this.operatingSystemType = (OperatingSystemType)this.resourcesType.eGet(eStructuralFeature);
                            if (this.operatingSystemType.getOperatingSystemType() != null) {
                                comboName = this.comboFeaturesMap.get(featureID);
                                comboName.setText(this.operatingSystemType.getOperatingSystemType().getOperatingSystemName().getLiteral());
                            }
                            if (this.operatingSystemType.getOperatingSystemVersion() != null) {
                                widgetName = this.widgetFeaturesMap.get(37);
                                widgetName.setText(this.operatingSystemType.getOperatingSystemVersion());
                            }
                            if (this.operatingSystemType.getDescription() == null) continue block10;
                            widgetName = this.widgetFeaturesMap.get(12);
                            widgetName.setText(this.operatingSystemType.getDescription());
                            break;
                        }
                        case 1: {
                            tableViewer = this.viewerFeaturesMap.get(featureID);
                            EList valueEList = (EList)this.resourcesType.eGet(eStructuralFeature);
                            if (!this.viewerFeaturesMap.containsKey(featureID)) continue block10;
                            for (FileSystemType this.fileSystemType : valueEList) {
                                tableViewer.setInput((Object)valueEList);
                            }
                            continue block10;
                        }
                        case 4: {
                            this.cpuArchitectureType = (CPUArchitectureType)this.resourcesType.eGet(eStructuralFeature);
                            comboName = this.comboFeaturesMap.get(featureID);
                            comboName.setText(this.cpuArchitectureType.getCPUArchitectureName().getLiteral());
                            break;
                        }
                    }
                    continue;
                }
                switch (featureID) {
                    case 2: {
                        boolean value = this.resourcesType.isExclusiveExecution();
                        comboName = this.comboFeaturesMap.get(featureID);
                        comboName.setText(Boolean.toString(value));
                        break;
                    }
                }
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

