/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.jsdl.model.base.CandidateHostsType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.CandidateHostsDialog;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CandidateHostsSection
extends JsdlFormPageSection {
    private static final int TXT_LENGTH = 300;
    private static final int WIDGET_HEIGHT = 100;
    protected Object[] value = null;
    protected Button btnHostsAdd = null;
    protected Button btnHostsDel = null;
    protected TableViewer hostsViewer = null;
    protected TableViewer fileSystemsViewer = null;
    protected JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();
    protected ResourcesType resourcesType = JsdlFactory.eINSTANCE.createResourcesType();
    protected CandidateHostsType candidateHosts = JsdlFactory.eINSTANCE.createCandidateHostsType();
    private FormPage containerPage = null;
    private Composite containerComposite = null;

    public CandidateHostsSection(FormPage formPage, Composite parent, FormToolkit toolkit) {
        this.containerPage = formPage;
        this.containerComposite = parent;
        this.createSection(parent, toolkit);
    }

    public void setInput(JobDefinitionType jobDefinitionType) {
        this.adapterRefreshed = true;
        this.jobDescriptionType = jobDefinitionType.getJobDescription();
        if (this.jobDescriptionType.getResources() != null) {
            this.resourcesType = this.jobDescriptionType.getResources();
        }
        this.fillFields();
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("ResourcesPage_CanHost");
        String sectionDescription = Messages.getString("ResourcesPage_CandHostDesc");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 2);
        GridData gd = new GridData();
        Table tblHosts = new Table(client, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 5;
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        gd.widthHint = 300;
        tblHosts.setLayoutData((Object)gd);
        this.hostsViewer = new TableViewer(tblHosts);
        tblHosts = this.hostsViewer.getTable();
        this.hostsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        FeatureLabelProvider hostsLabelProvider = new FeatureLabelProvider();
        hostsLabelProvider.setStringType(4);
        this.hostsViewer.setLabelProvider((IBaseLabelProvider)hostsLabelProvider);
        this.hostsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CandidateHostsSection.this.updateButtons((TableViewer)event.getSource());
            }
        });
        tblHosts.setData((Object)"FormWidgetFactory.drawBorder");
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 3;
        gd.horizontalAlignment = 4;
        this.btnHostsAdd = toolkit.createButton(client, Messages.getString("JsdlEditor_AddButton"), 524288);
        this.btnHostsAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CandidateHostsSection.this.handleAddDialog(Messages.getString("ResourcesPage_NewHostNameDialog"));
                CandidateHostsSection.this.addCandidateHosts(CandidateHostsSection.this.hostsViewer, CandidateHostsSection.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnHostsAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalSpan = 1;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.btnHostsDel = toolkit.createButton(client, Messages.getString("JsdlEditor_RemoveButton"), 524288);
        this.btnHostsDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CandidateHostsSection.this.performDelete(CandidateHostsSection.this.hostsViewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnHostsDel.setEnabled(false);
        this.btnHostsDel.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.updateButtons(this.hostsViewer);
    }

    protected void handleAddDialog(String dialogTitle) {
        this.value = null;
        CandidateHostsDialog hostsDialog = new CandidateHostsDialog(this.containerComposite.getShell(), dialogTitle);
        IFile file = ((IFileEditorInput)this.containerPage.getEditor().getEditorInput()).getFile();
        IGridRoot root = GridModel.getRoot();
        IGridElement element = root.findElement((IResource)file);
        hostsDialog.setDialogInput(element);
        hostsDialog.setExistingCandidateHosts(this.hostsViewer.getInput());
        if (hostsDialog.open() != 0) {
            return;
        }
        this.value = hostsDialog.getValue();
    }

    public void addCandidateHosts(TableViewer tableViewer, Object[] innerValue) {
        if (innerValue == null) {
            return;
        }
        ArrayList<String> collection = new ArrayList<String>();
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i = 0;
        while (i < innerValue.length) {
            newInputList.add((Object)((String)innerValue[i]));
            ++i;
        }
        i = 0;
        while (i < newInputList.size()) {
            collection.add((String)newInputList.get(i));
            ++i;
        }
        this.checkCandidateHostsElement();
        this.candidateHosts.getHostName().clear();
        this.candidateHosts.getHostName().addAll(collection);
        tableViewer.setInput((Object)this.candidateHosts.getHostName());
        this.contentChanged();
        collection = null;
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        if (structSelection != null) {
            for (Object feature : structSelection) {
                try {
                    if (!this.adapterRefreshed) {
                        if (feature instanceof String) {
                            this.candidateHosts.getHostName().remove(feature);
                            if (this.candidateHosts.getHostName().size() == 0) {
                                EcoreUtil.remove((EObject)this.candidateHosts);
                                this.checkResourcesElement();
                            }
                        }
                        this.contentChanged();
                    } else {
                        viewer.remove(feature);
                    }
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                viewer.refresh();
            }
        }
    }

    protected void checkResourcesElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(2);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.resourcesType);
        } else if (!this.resourcesType.isExclusiveExecution() && this.resourcesType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.resourcesType);
        }
    }

    protected void checkCandidateHostsElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(0);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            this.resourcesType.eSet(eStructuralFeature, (Object)this.candidateHosts);
        }
    }

    protected void updateButtons(TableViewer tableViewer) {
        ISelection selection = tableViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.btnHostsAdd.setEnabled(true);
        this.btnHostsDel.setEnabled(selectionAvailable);
    }

    private void fillFields() {
        if (this.resourcesType.getCandidateHosts() != null) {
            this.candidateHosts = this.resourcesType.getCandidateHosts();
            EList valueEList = this.candidateHosts.getHostName();
            this.hostsViewer.setInput((Object)valueEList);
        }
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

