/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.CPUArchitectureType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.ProcessorArchitectureEnumeration;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import java.util.Arrays;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class CpuArchitectureSection
extends JsdlFormPageSection {
    protected JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();
    protected ResourcesType resourcesType = JsdlFactory.eINSTANCE.createResourcesType();
    protected CPUArchitectureType cpuArchitectureType;
    protected Label lblCPUArchName = null;
    protected Combo cmbCPUArchName = null;

    public CpuArchitectureSection(Composite parent, FormToolkit toolkit) {
        this.createSection(parent, toolkit);
    }

    public void setInput(JobDefinitionType jobDefinitionType) {
        this.adapterRefreshed = true;
        this.jobDescriptionType = jobDefinitionType.getJobDescription();
        if (this.jobDescriptionType.getResources() != null) {
            this.resourcesType = this.jobDescriptionType.getResources();
        }
        this.fillFields();
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("ResourcesPage_CPUArch");
        String sectionDescription = Messages.getString("ResourcesPage_CPUArchDescr");
        Composite client = FormSectionFactory.createStaticSection(toolkit, parent, sectionTitle, sectionDescription, 2);
        TableWrapData td = new TableWrapData(256);
        this.lblCPUArchName = toolkit.createLabel(client, Messages.getString("ResourcesPage_CPUArchName"));
        this.cmbCPUArchName = new Combo(client, 76);
        this.cmbCPUArchName.setData((Object)"FormWidgetFactory.drawBorder");
        EEnum cFEnum = JsdlPackage.Literals.PROCESSOR_ARCHITECTURE_ENUMERATION;
        this.cmbCPUArchName.add("");
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            this.cmbCPUArchName.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        cFEnum = null;
        Object[] sortedTypes = this.cmbCPUArchName.getItems();
        Arrays.sort(sortedTypes);
        this.cmbCPUArchName.setItems((String[])sortedTypes);
        this.cmbCPUArchName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedCPUArch = CpuArchitectureSection.this.cmbCPUArchName.getItem(CpuArchitectureSection.this.cmbCPUArchName.getSelectionIndex());
                if (selectedCPUArch.equals("")) {
                    CpuArchitectureSection.this.deleteElement((EObject)CpuArchitectureSection.this.cpuArchitectureType);
                    CpuArchitectureSection.this.cpuArchitectureType = null;
                } else {
                    CpuArchitectureSection.this.checkCPUArch();
                    CpuArchitectureSection.this.cpuArchitectureType.setCPUArchitectureName(ProcessorArchitectureEnumeration.get((String)selectedCPUArch));
                    CpuArchitectureSection.this.resourcesType.setCPUArchitecture(CpuArchitectureSection.this.cpuArchitectureType);
                }
                CpuArchitectureSection.this.contentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbCPUArchName.setLayoutData((Object)td);
        toolkit.paintBordersFor(client);
    }

    protected void deleteElement(EObject eStructuralFeature) {
        try {
            EcoreUtil.remove((EObject)eStructuralFeature);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.resourcesType);
        }
        return eObject;
    }

    protected void checkCPUArch() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(4);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            if (this.cpuArchitectureType == null) {
                this.cpuArchitectureType = JsdlFactory.eINSTANCE.createCPUArchitectureType();
            }
            this.resourcesType.eSet(eStructuralFeature, (Object)this.cpuArchitectureType);
        }
    }

    protected void checkResourcesElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(2);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.resourcesType);
        } else if (!this.resourcesType.isExclusiveExecution() && this.resourcesType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.resourcesType);
        }
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.resourcesType.getCPUArchitecture() != null) {
            this.cpuArchitectureType = this.resourcesType.getCPUArchitecture();
            this.cmbCPUArchName.setText(this.cpuArchitectureType.getCPUArchitectureName().getLiteral());
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

