/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.DataStagingInDialog;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.DataStageInLabelProvider;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStageInSection
extends JsdlFormPageSection {
    private static final int WIDGET_HEIGHT = 170;
    protected Button btnStageInAdd = null;
    protected Button btnStageInEdit = null;
    protected Button btnStageInDel = null;
    protected Table tblStageIn = null;
    protected TableViewer stageInViewer = null;
    protected ArrayList<DataStagingType> dataStageList = new ArrayList();
    private TableColumn column;
    private Composite containerComposite = null;
    private DataStagingType dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
    private JobDescriptionType jobDescriptionType = null;
    private JobDefinitionType jobDefinitionType = null;
    private EList<DataStagingType> dataStageInputList = null;

    public DataStageInSection(Composite parent, FormToolkit toolkit) {
        this.containerComposite = parent;
        this.createSection(parent, toolkit);
    }

    private void createSection(Composite parentComposite, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("DataStagingPage_StageInSection");
        String sectionDescription = Messages.getString("DataStagingPage_StageInDescr");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parentComposite, sectionTitle, sectionDescription, 3);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 1;
        gd.widthHint = 600;
        gd.heightHint = 170;
        this.stageInViewer = new TableViewer(client, 67586);
        this.tblStageIn = this.stageInViewer.getTable();
        this.tblStageIn.setHeaderVisible(true);
        this.tblStageIn.setLinesVisible(true);
        this.stageInViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.stageInViewer.setLabelProvider((IBaseLabelProvider)new DataStageInLabelProvider());
        this.column = new TableColumn(this.tblStageIn, 16384);
        this.column.setText(Messages.getString("DataStagingPage_Source"));
        this.column.setWidth(200);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_FileName"));
        this.column.setWidth(150);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_CreationFlag"));
        this.column.setWidth(100);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_DeleteOnTermination"));
        this.column.setWidth(100);
        this.stageInViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return ((DataStagingType)element).getSource() != null;
            }
        });
        this.stageInViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataStageInSection.this.updateButtons((TableViewer)event.getSource());
            }
        });
        this.tblStageIn.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.tblStageIn.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnStageInAdd = toolkit.createButton(client, Messages.getString("JsdlEditor_AddButton"), 8);
        this.btnStageInAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInSection.this.handleEventDialog(null);
                DataStageInSection.this.performAdd(DataStageInSection.this.stageInViewer, DataStageInSection.this.dataStageList);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnStageInAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnStageInEdit = toolkit.createButton(client, Messages.getString("JsdlEditor_EditButton"), 8);
        this.btnStageInEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInSection.this.handleEventDialog(DataStageInSection.this.getViewerSelectionObject(DataStageInSection.this.stageInViewer));
                DataStageInSection.this.performEdit(DataStageInSection.this.stageInViewer, DataStageInSection.this.dataStageList);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnStageInEdit.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        gd.verticalAlignment = 1;
        this.btnStageInDel = toolkit.createButton(client, Messages.getString("JsdlEditor_RemoveButton"), 8);
        this.btnStageInDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInSection.this.performDelete(DataStageInSection.this.stageInViewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnStageInDel.setLayoutData((Object)gd);
        this.updateButtons(this.stageInViewer);
        toolkit.paintBordersFor(client);
    }

    protected DataStagingType getViewerSelectionObject(TableViewer tableViewer) {
        DataStagingType result = null;
        IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof DataStagingType) {
            result = (DataStagingType)obj;
        }
        return result;
    }

    protected void handleEventDialog(DataStagingType selectedObject) {
        if (selectedObject == null) {
            DataStagingInDialog dialog = new DataStagingInDialog(this.containerComposite.getShell(), 1);
            if (dialog.open() == 0) {
                this.dataStageList = dialog.getDataStageInList();
            }
        } else {
            DataStagingInDialog dialog = new DataStagingInDialog(this.containerComposite.getShell(), 1, selectedObject);
            if (dialog.open() == 0) {
                this.dataStageList = dialog.getDataStageInList();
            }
        }
    }

    public void performAdd(TableViewer tableViewer, ArrayList<DataStagingType> innerDataStageList) {
        if (innerDataStageList.isEmpty()) {
            return;
        }
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i = 0;
        while (i < innerDataStageList.size()) {
            boolean exists = this.doesElementExists(this.dataStagingType, innerDataStageList.get(i), (EList<DataStagingType>)newInputList);
            if (!exists) {
                newInputList.add((Object)innerDataStageList.get(i));
                try {
                    this.jobDescriptionType.getDataStaging().addAll((Collection)newInputList);
                    tableViewer.setInput((Object)this.jobDescriptionType.getDataStaging());
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                tableViewer.refresh();
                this.contentChanged();
            } else {
                MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("DataStagingPage_DuplicateEntryDialog_Title"), (String)Messages.getString("DataStagingPage_New_DuplicateEntryDialog_Message"));
            }
            ++i;
        }
        newInputList = null;
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        Iterator it = structSelection.iterator();
        POSIXApplicationType posixApplicationType = null;
        TreeIterator iterator = this.jobDefinitionType.eAllContents();
        while (iterator.hasNext()) {
            EObject testType = (EObject)iterator.next();
            if (!(testType instanceof POSIXApplicationType)) continue;
            posixApplicationType = (POSIXApplicationType)testType;
        }
        while (it.hasNext()) {
            Object feature = it.next();
            DataStagingType selectedDataStage = (DataStagingType)feature;
            try {
                if (posixApplicationType != null) {
                    if (posixApplicationType.getOutput() != null && posixApplicationType.getOutput().getValue().equals(selectedDataStage.getFileName())) {
                        posixApplicationType.setOutput(null);
                    } else if (posixApplicationType.getInput() != null && posixApplicationType.getInput().getValue().equals(selectedDataStage.getFileName())) {
                        posixApplicationType.setInput(null);
                    } else if (posixApplicationType.getError() != null) {
                        posixApplicationType.setError(null);
                    }
                }
                EcoreUtil.remove((EObject)selectedDataStage);
            }
            catch (Exception e) {
                Activator.logException(e);
            }
            viewer.refresh();
            this.contentChanged();
        }
    }

    public void performEdit(TableViewer tableViewer, ArrayList<DataStagingType> innerDataStageList) {
        if (innerDataStageList.isEmpty()) {
            return;
        }
        EList newInputList = (EList)tableViewer.getInput();
        int featureID = 3;
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            int i = 0;
            while (i < innerDataStageList.size()) {
                EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(featureID);
                Object oldDataStageElement = structSelection.getFirstElement();
                int index = ((List)this.jobDescriptionType.eGet(eStructuralFeature)).indexOf(oldDataStageElement);
                this.dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
                this.dataStagingType = innerDataStageList.get(i);
                if (!this.doesElementExists((DataStagingType)oldDataStageElement, this.dataStagingType, (EList<DataStagingType>)newInputList)) {
                    ((List)this.jobDescriptionType.eGet(eStructuralFeature)).set(index, this.dataStagingType);
                    tableViewer.refresh();
                    this.contentChanged();
                } else {
                    MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("DataStagingPage_DuplicateEntryDialog_Title"), (String)Messages.getString("DataStagingPage_Edit_DuplicateEntryDialog_Message"));
                }
                ++i;
            }
        }
    }

    private boolean doesElementExists(DataStagingType oldDataStage, DataStagingType newDataStage, EList<DataStagingType> inputList) {
        boolean result = false;
        if (newDataStage.getSource() != null) {
            for (DataStagingType data : inputList) {
                if (data.equals(oldDataStage) || data.getSource() == null || !data.getFileName().equals(newDataStage.getFileName()) || !data.getSource().getURI().equals(newDataStage.getSource().getURI())) continue;
                result = true;
            }
        } else {
            for (DataStagingType data : inputList) {
                if (data.equals(oldDataStage) || data.getTarget() == null || !data.getFileName().equals(newDataStage.getFileName()) || !data.getTarget().getURI().equals(newDataStage.getTarget().getURI())) continue;
                result = true;
            }
        }
        return result;
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            this.jobDescriptionType = jobDefinition.getJobDescription();
            if (this.jobDescriptionType != null && this.jobDescriptionType.getDataStaging() != null) {
                this.dataStageInputList = this.jobDescriptionType.getDataStaging();
                this.fillFields();
            }
        }
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        this.stageInViewer.setInput(this.dataStageInputList);
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }

    protected void updateButtons(TableViewer tableViewer) {
        ISelection selection = tableViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.btnStageInAdd.setEnabled(true);
        this.btnStageInDel.setEnabled(selectionAvailable);
        this.btnStageInEdit.setEnabled(selectionAvailable);
    }
}

