/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.FileSystemsDialog;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FileSystemSection
extends JsdlFormPageSection {
    private static final int TXT_LENGTH = 300;
    private static final int WIDGET_HEIGHT = 100;
    protected JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();
    protected ResourcesType resourcesType = JsdlFactory.eINSTANCE.createResourcesType();
    protected FileSystemType fileSystemType;
    protected Button btnFileSystemAdd = null;
    protected Button btnFileSystemDel = null;
    protected Button btnFileSystemEdit = null;
    protected TableViewer fileSystemsViewer = null;
    protected Object value = null;
    private Table tblFileSystems = null;
    private TableColumn column = null;
    private Composite containerComposite = null;

    public FileSystemSection(Composite parent, FormToolkit toolkit) {
        this.containerComposite = parent;
        this.createSection(parent, toolkit);
    }

    public void setInput(JobDefinitionType jobDefinitionType) {
        this.adapterRefreshed = true;
        this.jobDescriptionType = jobDefinitionType.getJobDescription();
        if (this.jobDescriptionType.getResources() != null) {
            this.resourcesType = this.jobDescriptionType.getResources();
        }
        this.fillFields();
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("ResourcesPage_FileSystem");
        String sectionDescription = Messages.getString("ResourcesPage_FileSystemDesc");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 2);
        GridData gd = new GridData();
        this.tblFileSystems = new Table(client, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 5;
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        gd.widthHint = 300;
        this.tblFileSystems.setLayoutData((Object)gd);
        this.fileSystemsViewer = new TableViewer(this.tblFileSystems);
        this.tblFileSystems = this.fileSystemsViewer.getTable();
        this.fileSystemsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.fileSystemsViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        this.tblFileSystems.setHeaderVisible(true);
        this.column = new TableColumn(this.tblFileSystems, 0);
        this.column.setText("Name");
        this.column.setWidth(150);
        this.column = new TableColumn(this.tblFileSystems, 0);
        this.column.setText("Type");
        this.column.setWidth(60);
        this.column = new TableColumn(this.tblFileSystems, 0);
        this.column.setText("Mount Point");
        this.column.setWidth(60);
        this.fileSystemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileSystemSection.this.updateButtons((TableViewer)event.getSource());
            }
        });
        this.tblFileSystems.setData((Object)"FormWidgetFactory.drawBorder");
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 3;
        gd.horizontalAlignment = 4;
        this.btnFileSystemAdd = toolkit.createButton(client, Messages.getString("JsdlEditor_AddButton"), 524288);
        this.btnFileSystemAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileSystemSection.this.handleAddFsDialog(Messages.getString("ResourcesPage_NewFileSystemsDialog"), (Button)event.getSource());
                FileSystemSection.this.addFileSystem(FileSystemSection.this.fileSystemsViewer, FileSystemSection.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnFileSystemAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 3;
        gd.horizontalAlignment = 4;
        this.btnFileSystemEdit = toolkit.createButton(client, Messages.getString("JsdlEditor_EditButton"), 524288);
        this.btnFileSystemEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileSystemSection.this.handleAddFsDialog(Messages.getString("ResourcesPage_EditHostNameDialog"), (Button)event.getSource());
                FileSystemSection.this.performEdit(FileSystemSection.this.fileSystemsViewer, FileSystemSection.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnFileSystemEdit.setEnabled(false);
        this.btnFileSystemEdit.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalSpan = 1;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.btnFileSystemDel = toolkit.createButton(client, Messages.getString("JsdlEditor_RemoveButton"), 524288);
        this.btnFileSystemDel.setEnabled(false);
        this.btnFileSystemDel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileSystemSection.this.performDelete(FileSystemSection.this.fileSystemsViewer);
            }
        });
        this.btnFileSystemDel.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
    }

    protected void handleAddFsDialog(String dialogTitle, Button button) {
        this.value = null;
        FileSystemsDialog fileSystemDialog = new FileSystemsDialog(this.containerComposite.getShell(), dialogTitle);
        if (button != this.btnFileSystemAdd) {
            IStructuredSelection structSelection = (IStructuredSelection)this.fileSystemsViewer.getSelection();
            fileSystemDialog.setInput(structSelection.getFirstElement());
        }
        if (fileSystemDialog.open() != 0) {
            return;
        }
        this.value = fileSystemDialog.getValue();
    }

    public void addFileSystem(TableViewer tableViewer, Object innerValue) {
        boolean elementExists = false;
        if (innerValue == null) {
            return;
        }
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        this.fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
        this.fileSystemType = (FileSystemType)innerValue;
        String newElement = this.fileSystemType.getName();
        Iterator iter = newInputList.iterator();
        while (iter.hasNext() && !elementExists) {
            elementExists = ((FileSystemType)iter.next()).getName().equals(newElement);
        }
        if (!elementExists) {
            newInputList.add((Object)this.fileSystemType);
            this.resourcesType.getFileSystem().addAll((Collection)newInputList);
            tableViewer.setInput((Object)this.resourcesType.getFileSystem());
            tableViewer.refresh();
            this.contentChanged();
        } else {
            MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("FileSystem_DuplicateEntryDialog_Title"), (String)Messages.getString("FileSystem_New_DuplicateEntryDialog_Message"));
        }
    }

    public void performEdit(TableViewer tableViewer, Object innerValue) {
        boolean elementExists = false;
        if (innerValue == null) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            EList newInputList = (EList)tableViewer.getInput();
            if (newInputList == null) {
                newInputList = new BasicEList();
            }
            Object feature = structSelection.getFirstElement();
            int featureID = 1;
            EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(featureID);
            int index = ((List)this.resourcesType.eGet(eStructuralFeature)).indexOf(feature);
            this.fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
            this.fileSystemType = (FileSystemType)innerValue;
            String newElement = this.fileSystemType.getName();
            Iterator iter = newInputList.iterator();
            while (iter.hasNext() && !elementExists) {
                FileSystemType tempFileSystemType = (FileSystemType)iter.next();
                if (!tempFileSystemType.getName().equals(newElement) || tempFileSystemType.equals(feature)) continue;
                elementExists = true;
            }
            if (!elementExists) {
                ((List)this.resourcesType.eGet(eStructuralFeature)).set(index, this.fileSystemType);
                tableViewer.refresh();
                this.contentChanged();
            } else {
                MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("FileSystem_DuplicateEntryDialog_Title"), (String)Messages.getString("FileSystem_New_DuplicateEntryDialog_Message"));
            }
            eStructuralFeature = null;
        }
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        for (Object feature : structSelection) {
            if (!(feature instanceof FileSystemType)) continue;
            FileSystemType argument = (FileSystemType)feature;
            try {
                EcoreUtil.remove((EObject)argument);
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
        viewer.refresh();
        this.contentChanged();
    }

    protected void checkResourcesElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(2);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.resourcesType);
        } else if (!this.resourcesType.isExclusiveExecution() && this.resourcesType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.resourcesType);
        }
    }

    protected void checkFileSystemElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(1);
        ArrayList<FileSystemType> collection = new ArrayList<FileSystemType>();
        if (this.fileSystemType == null) {
            this.fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
        }
        collection.add(this.fileSystemType);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            this.resourcesType.eSet(eStructuralFeature, collection);
        }
    }

    protected void updateButtons(TableViewer tableViewer) {
        ISelection selection = tableViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.btnFileSystemAdd.setEnabled(true);
        this.btnFileSystemEdit.setEnabled(selectionAvailable);
        this.btnFileSystemDel.setEnabled(selectionAvailable);
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.resourcesType.getFileSystem() != null) {
            EList valueEList = this.resourcesType.getFileSystem();
            for (FileSystemType this.fileSystemType : valueEList) {
                this.fileSystemsViewer.setInput((Object)valueEList);
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

