/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.wizards;

import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.internal.wizards.Messages;
import eu.geclipse.jsdl.ui.internal.wizards.ValueWithEpsilon;
import eu.geclipse.ui.widgets.TabComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLExactValueTab
extends TabComponent {
    public JSDLExactValueTab(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> columnsProperties, int hight, int width) {
        super(contentProvider, labelProvider, columnsProperties, hight, width);
    }

    protected void handleAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), Messages.getString("JSDLExactValueTab.new_value"));
        dialog.addTextField(Messages.getString("JSDLExactValueTab.value"), null, false);
        dialog.addTextField(Messages.getString("JSDLExactValueTab.epsilon"), null, false);
        if (dialog.open() != 0) {
            return;
        }
        String val = dialog.getStringValue(Messages.getString("JSDLExactValueTab.value"));
        String eps = dialog.getStringValue(Messages.getString("JSDLExactValueTab.epsilon"));
        try {
            ValueWithEpsilon value = new ValueWithEpsilon(Double.valueOf(val), Double.valueOf(eps));
            this.addVariable(value);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLExactValueTab.bad_number_format"), (String)Messages.getString("JSDLExactValueTab.bad_number_format"));
        }
    }

    protected void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.table.getSelection();
        ValueWithEpsilon var = (ValueWithEpsilon)sel.getFirstElement();
        if (var != null) {
            String oldStart = Double.valueOf(var.getValue()).toString();
            String oldEnd = Double.valueOf(var.getEpsilon()).toString();
            MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), Messages.getString("JSDLExactValueTab.edit_title"));
            ArrayList<String> comboData = new ArrayList<String>();
            FileType[] fileTypeArray = FileType.values();
            int n = fileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileType fileType = fileTypeArray[n2];
                comboData.add(fileType.toString());
                ++n2;
            }
            dialog.addTextField(Messages.getString("JSDLExactValueTab.value"), oldStart, false);
            dialog.addTextField(Messages.getString("JSDLExactValueTab.epsilon"), oldEnd, false);
            if (dialog.open() == 0) {
                try {
                    String newStart = dialog.getStringValue(Messages.getString("JSDLExactValueTab.value"));
                    String newEnd = dialog.getStringValue(Messages.getString("JSDLExactValueTab.epsilon"));
                    if (!oldStart.equals(newStart) || !oldEnd.equals(newEnd)) {
                        ValueWithEpsilon newRange = new ValueWithEpsilon(Double.valueOf(newStart), Double.valueOf(newEnd));
                        if (this.addVariable(newRange)) {
                            this.table.remove((Object)var);
                        }
                    } else {
                        var.setValue(Double.valueOf(newStart));
                        var.setEpsilon(Double.valueOf(newEnd));
                        this.table.update((Object)var, null);
                        this.updateLaunchConfigurationDialog();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLExactValueTab.bad_number_format"), (String)Messages.getString("JSDLExactValueTab.bad_number_format"));
                }
            }
        }
    }

    protected void handleRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.table.getSelection();
        this.table.getControl().setRedraw(false);
        for (ValueWithEpsilon var : sel) {
            this.table.remove((Object)var);
        }
        this.table.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void setLabels() {
        this.addButton.setText(Messages.getString("JSDLExactValueTab.add_button"));
        this.editButton.setText(Messages.getString("JSDLExactValueTab.edit_button"));
        this.removeButton.setText(Messages.getString("JSDLExactValueTab.rmove_button"));
    }
}

