/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.preference;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridApplication;
import eu.geclipse.core.model.IGridApplicationParameters;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.GridApplicationParameters;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.preference.ApplicationParametersException;
import eu.geclipse.jsdl.ui.preference.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationParametersRegistry
implements IContentChangeNotifier {
    private static final String DIRECTORY_NAME = ".appsData";
    private static final String APP_NAME_PREFIX = "appName=";
    private static final String APP_PATH_PREFIX = "appPath=";
    private static final String XML_PATH_PREFIX = "XMLPath=";
    private static final String JSDL_PATH_PEFIX = "JSDLPath=";
    private static final String VO_PATH_PREFIX = "VOName=";
    private static ApplicationParametersRegistry instance;
    int currentIdPointer = 0;
    private List<IGridApplicationParameters> userAppsParamsList = new ArrayList<IGridApplicationParameters>(){
        private static final long serialVersionUID = -6190123705427391030L;

        @Override
        public boolean add(IGridApplicationParameters param) {
            param.setId(ApplicationParametersRegistry.this.currentIdPointer);
            ++ApplicationParametersRegistry.this.currentIdPointer;
            return super.add(param);
        }
    };
    private List<IGridApplicationParameters> generatedAppsParamList = new ArrayList<IGridApplicationParameters>(){
        private static final long serialVersionUID = 1433643044865859460L;

        @Override
        public boolean add(IGridApplicationParameters param) {
            param.setId(ApplicationParametersRegistry.this.currentIdPointer);
            ++ApplicationParametersRegistry.this.currentIdPointer;
            return super.add(param);
        }
    };
    private Map<IGridApplicationParameters, String> appSpecObjectsToFiles = new HashMap<IGridApplicationParameters, String>();
    private ListenerList ccListeners = new ListenerList();

    private ApplicationParametersRegistry() {
        this.userAppsParamsList = new ArrayList<IGridApplicationParameters>();
        IPath location = Activator.getDefault().getStateLocation();
        location = location.append(DIRECTORY_NAME);
        File file = location.toFile();
        if (file.exists()) {
            String[] names;
            String[] stringArray = names = file.list();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                GridApplicationParameters asO = this.readDataFile(new Path(file.getAbsolutePath()).append(name));
                if (asO != null) {
                    this.userAppsParamsList.add((IGridApplicationParameters)asO);
                }
                ++n2;
            }
        }
    }

    public static ApplicationParametersRegistry getInstance() {
        if (instance == null) {
            instance = new ApplicationParametersRegistry();
        }
        return instance;
    }

    public List<IGridApplicationParameters> getApplicationParameters(IVirtualOrganization vo) {
        ArrayList<IGridApplicationParameters> result = new ArrayList<IGridApplicationParameters>();
        for (IGridApplicationParameters param : this.userAppsParamsList) {
            if (vo != null && !param.getVO().equals(vo)) continue;
            result.add(param);
        }
        for (IGridApplicationParameters param : this.generatedAppsParamList) {
            if (vo != null && !param.getVO().equals(vo)) continue;
            result.add(param);
        }
        return result;
    }

    public void updateApplicationsParameters(IVirtualOrganization vo, IProgressMonitor monitor) throws ProblemException {
        monitor.beginTask(Messages.getString("ApplicationParametersRegistry.fetching_information"), -1);
        if (vo == null) {
            IGridElement[] els = GridModel.getVoManager().getChildren((IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            IGridElement[] iGridElementArray = els;
            int n = els.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement el = iGridElementArray[n2];
                if (el instanceof IVirtualOrganization) {
                    IVirtualOrganization singleVO = (IVirtualOrganization)el;
                    ArrayList<IGridApplicationParameters> params = new ArrayList<IGridApplicationParameters>();
                    IGridResource[] resources = null;
                    monitor.setTaskName(Messages.getString("ApplicationParametersRegistry.fetching_apps_list"));
                    resources = singleVO.getAvailableResources(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.applications"), false, (IProgressMonitor)new NullProgressMonitor());
                    monitor.worked(1);
                    if (resources != null) {
                        IGridResource[] iGridResourceArray = resources;
                        int n3 = resources.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IGridResource param = iGridResourceArray[n4];
                            monitor.setTaskName(Messages.getString("ApplicationParametersRegistry.processing_apps_data"));
                            IGridApplicationParameters parameter = ((IGridApplication)param).getApplicationParameters();
                            if (parameter != null) {
                                params.add(parameter);
                            }
                            monitor.worked(1);
                            ++n4;
                        }
                    } else {
                        throw new ProblemException("eu.geclipse.core.problem.model.fetchChildrenFailed", Messages.getString("ApplicationParametersRegistry.cannot_fetch_resources"), "eu.geclipse.jsdl.ui");
                    }
                    monitor.setTaskName(Messages.getString("ApplicationParametersRegistry.updating_registry"));
                    this.replaceParametersForVO(singleVO, params);
                    monitor.worked(1);
                }
                ++n2;
            }
        } else {
            monitor.beginTask(Messages.getString("ApplicationParametersRegistry.fetching_apps_list"), -1);
            ArrayList<IGridApplicationParameters> params = new ArrayList<IGridApplicationParameters>();
            IGridResource[] resources = null;
            resources = vo.getAvailableResources(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.applications"), false, (IProgressMonitor)new NullProgressMonitor());
            if (resources != null) {
                IGridResource[] iGridResourceArray = resources;
                int n = resources.length;
                int n5 = 0;
                while (n5 < n) {
                    IGridResource param = iGridResourceArray[n5];
                    monitor.setTaskName(Messages.getString("ApplicationParametersRegistry.processing_apps_data"));
                    IGridApplicationParameters parameter = ((IGridApplication)param).getApplicationParameters();
                    if (parameter != null) {
                        params.add(parameter);
                    }
                    monitor.worked(1);
                    ++n5;
                }
            } else {
                throw new ProblemException("eu.geclipse.core.problem.model.fetchChildrenFailed", Messages.getString("ApplicationParametersRegistry.cannot_fetch_resources"), "eu.geclipse.jsdl.ui");
            }
            monitor.setTaskName(Messages.getString("ApplicationParametersRegistry.updating_registry"));
            this.replaceParametersForVO(vo, params);
            monitor.worked(1);
        }
    }

    private void replaceParametersForVO(IVirtualOrganization vo, List<IGridApplicationParameters> newParams) {
        this.removeParamsForVO(vo);
        this.internalAddParams(newParams, 1);
    }

    private void internalAddParams(List<IGridApplicationParameters> newParams, int list) {
        block5: {
            block4: {
                if (list != 1) break block4;
                for (IGridApplicationParameters param : newParams) {
                    this.generatedAppsParamList.add(param);
                    this.notifyListeners();
                }
                break block5;
            }
            if (list != 0) break block5;
            for (IGridApplicationParameters param : newParams) {
                try {
                    this.saveObjectToDisc(param);
                    this.userAppsParamsList.add(param);
                    this.notifyListeners();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void removeParamsForVO(IVirtualOrganization vo) {
        Iterator<IGridApplicationParameters> iterator = this.generatedAppsParamList.iterator();
        while (iterator.hasNext()) {
            IGridApplicationParameters param = iterator.next();
            if (!param.getVO().equals(vo)) continue;
            iterator.remove();
            this.notifyListeners();
        }
    }

    private boolean removeParam(IGridApplicationParameters param) {
        boolean result = false;
        String fileName = this.appSpecObjectsToFiles.get(param);
        IPath path = Activator.getDefault().getStateLocation();
        path = path.append(DIRECTORY_NAME);
        path = path.append(this.appSpecObjectsToFiles.get(param));
        if (fileName != null) {
            File file = path.toFile();
            file.exists();
            result = file.delete();
        } else {
            result = true;
        }
        if (result) {
            if (this.userAppsParamsList.contains(param)) {
                this.userAppsParamsList.remove(param);
            } else if (this.generatedAppsParamList.contains(param)) {
                this.generatedAppsParamList.remove(param);
            }
        }
        return result;
    }

    private void saveObjectToDisc(IGridApplicationParameters aSO) throws IOException {
        IPath path = Activator.getDefault().getStateLocation();
        File directory = (path = path.append(DIRECTORY_NAME)).toFile();
        if (!directory.exists()) {
            directory.mkdir();
        }
        int name = aSO.getId();
        boolean canCreate = false;
        while (!canCreate) {
            if (path.append(Integer.valueOf(name).toString()).toFile().exists()) {
                ++name;
                continue;
            }
            path = path.append(Integer.valueOf(name).toString());
            canCreate = true;
        }
        File newFile = path.toFile();
        newFile.createNewFile();
        FileWriter writer = new FileWriter(newFile, true);
        writer.write(APP_NAME_PREFIX + aSO.getApplicationName() + "\n");
        writer.write(APP_PATH_PREFIX + aSO.getApplicationPath() + "\n");
        writer.write(XML_PATH_PREFIX + aSO.getXmlPath() + "\n");
        writer.write(JSDL_PATH_PEFIX + aSO.getJsdlPath() + "\n");
        String vo = "";
        if (aSO.getVO() != null) {
            vo = aSO.getVO().getName();
        }
        writer.write(VO_PATH_PREFIX + vo);
        writer.close();
        this.appSpecObjectsToFiles.put(aSO, Integer.valueOf(name).toString());
    }

    private GridApplicationParameters readDataFile(IPath filePath) {
        GridApplicationParameters result = null;
        File file = filePath.toFile();
        if (file.isFile()) {
            BufferedReader in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(file));
                    String appName = null;
                    String path = null;
                    Path xmlPath = null;
                    Path jsdlPath = null;
                    IVirtualOrganization vo = null;
                    boolean doCreate = true;
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith(APP_NAME_PREFIX)) {
                            appName = line.substring(APP_NAME_PREFIX.length()).trim();
                        }
                        if (line.startsWith(APP_PATH_PREFIX)) {
                            path = line.substring(APP_PATH_PREFIX.length()).trim();
                        }
                        if (line.startsWith(XML_PATH_PREFIX)) {
                            xmlPath = new Path(line.substring(XML_PATH_PREFIX.length()).trim());
                        }
                        if (line.startsWith(JSDL_PATH_PEFIX)) {
                            jsdlPath = new Path(line.substring(JSDL_PATH_PEFIX.length()).trim());
                        }
                        if (!line.startsWith(VO_PATH_PREFIX)) continue;
                        String voName = line.substring(VO_PATH_PREFIX.length()).trim();
                        vo = voName != "" ? (IVirtualOrganization)GridModel.getVoManager().findChild(voName) : null;
                    }
                    if (appName != null && path != null && xmlPath != null && doCreate) {
                        result = new GridApplicationParameters(appName, path, xmlPath, jsdlPath, vo);
                        this.appSpecObjectsToFiles.put((IGridApplicationParameters)result, filePath.lastSegment());
                    }
                }
                catch (FileNotFoundException fileNotFoundExc) {
                    Activator.logException(fileNotFoundExc);
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.logException(e);
                    }
                }
                catch (IOException ioExc) {
                    Activator.logException(ioExc);
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.logException(e);
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    Activator.logException(e);
                }
            }
        }
        return result;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.ccListeners == null) {
            this.ccListeners = new ListenerList();
        }
        this.ccListeners.add((Object)listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.ccListeners != null) {
            this.ccListeners.remove((Object)listener);
        }
    }

    protected void notifyListeners() {
        Object[] list = this.ccListeners.getListeners();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof IContentChangeListener) {
                IContentChangeListener listener = (IContentChangeListener)list[i];
                listener.contentChanged((IContentChangeNotifier)this);
            }
            ++i;
        }
    }

    public void removeApplicationParameters(GridApplicationParameters param) throws ApplicationParametersException {
        if (this.userAppsParamsList.contains(param)) {
            if (this.removeParam((IGridApplicationParameters)param)) {
                this.notifyListeners();
            }
        } else {
            throw new ApplicationParametersException((IStatus)new Status(4, "eu.geclipse.jsdl.ui", Messages.getString("ApplicationParametersRegistry.removing_not_allowed_exception")));
        }
    }

    public void addApplicationSpecificData(String appName, String appPath, Path xmlPath, Path jsdlPath, IVirtualOrganization vo) {
        GridApplicationParameters newObject = new GridApplicationParameters(appName, appPath, (IPath)xmlPath, (IPath)jsdlPath, vo);
        if (!this.userAppsParamsList.contains(newObject)) {
            try {
                this.saveObjectToDisc((IGridApplicationParameters)newObject);
                this.userAppsParamsList.add((IGridApplicationParameters)newObject);
                this.notifyListeners();
            }
            catch (IOException exc) {
                Activator.logException(exc);
            }
        }
    }

    public void editApplicationSpecificData(GridApplicationParameters oldASO, String newAppName, String newAppPath, String newXMLPath, String newJSDLPath) throws ApplicationParametersException {
        IPath path = Activator.getDefault().getStateLocation();
        try {
            if (!this.userAppsParamsList.contains(oldASO)) {
                throw new ApplicationParametersException((IStatus)new Status(4, "eu.geclipse.jsdl.ui", Messages.getString("ApplicationParametersRegistry.editing_not_allowed_exception")));
            }
            path = path.append(DIRECTORY_NAME);
            path = path.append(this.appSpecObjectsToFiles.get(oldASO));
            FileWriter writer = new FileWriter(path.toFile(), false);
            writer.write(APP_NAME_PREFIX + newAppName + "\n");
            writer.write(APP_PATH_PREFIX + newAppPath + "\n");
            writer.write(XML_PATH_PREFIX + newXMLPath + "\n");
            writer.write(JSDL_PATH_PEFIX + newJSDLPath);
            writer.close();
            oldASO.setApplicationName(newAppName);
            oldASO.setAppPath(newAppPath);
            oldASO.setXmlPath((IPath)new Path(newXMLPath));
            oldASO.setJSDLPath((IPath)new Path(newJSDLPath));
            this.notifyListeners();
        }
        catch (IOException exc) {
            Activator.logException(exc);
        }
    }

    public Map<String, Integer> getApplicationDataMapping(IVirtualOrganization vo) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList<IGridApplicationParameters> chosenParams = new ArrayList<IGridApplicationParameters>();
        HashMap<String, Integer> nameVsQuantity = new HashMap<String, Integer>();
        ArrayList<IVirtualOrganization> vos = new ArrayList<IVirtualOrganization>();
        if (vo == null) {
            IGridElement[] els = new IGridElement[]{};
            try {
                els = GridModel.getVoManager().getChildren((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProblemException e) {
                Activator.logException(e);
            }
            IGridElement[] iGridElementArray = els;
            int n = els.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement el = iGridElementArray[n2];
                if (el instanceof IVirtualOrganization) {
                    vos.add((IVirtualOrganization)el);
                }
                ++n2;
            }
        } else {
            vos.add(vo);
        }
        for (IGridApplicationParameters param : this.userAppsParamsList) {
            if (!vos.contains(param.getVO()) && param.getVO() != null) continue;
            chosenParams.add(param);
            String appName = param.getApplicationName();
            Integer occur = new Integer(0);
            if (nameVsQuantity.keySet().contains(appName)) {
                occur = (Integer)nameVsQuantity.get(appName);
            }
            nameVsQuantity.put(appName, new Integer(occur + 1));
        }
        for (IGridApplicationParameters param : this.generatedAppsParamList) {
            if (!vos.contains(param.getVO()) && param.getVO() != null) continue;
            chosenParams.add(param);
            String appName = param.getApplicationName();
            Integer occur = new Integer(0);
            if (nameVsQuantity.keySet().contains(appName)) {
                occur = (Integer)nameVsQuantity.get(appName);
            }
            nameVsQuantity.put(appName, new Integer(occur + 1));
        }
        for (IGridApplicationParameters param : chosenParams) {
            String sufix = "";
            int i = 1;
            while (i <= (Integer)nameVsQuantity.get(param.getApplicationName())) {
                if (i != 1) {
                    sufix = "[" + i + "]";
                }
                result.put(String.valueOf(param.getApplicationName()) + sufix, new Integer(param.getId()));
                ++i;
            }
        }
        return result;
    }

    public IGridApplicationParameters getApplicationData(int paramId) {
        IGridApplicationParameters result = null;
        boolean haveIt = false;
        for (IGridApplicationParameters param : this.userAppsParamsList) {
            if (param.getId() != paramId) continue;
            result = param;
            haveIt = true;
            break;
        }
        if (!haveIt) {
            for (IGridApplicationParameters param : this.generatedAppsParamList) {
                if (param.getId() != paramId) continue;
                result = param;
                haveIt = true;
                break;
            }
        }
        return result;
    }
}

