/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.providers;

import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.ui.internal.Activator;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DataStageOutLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image stageOutImage;
    private Image stageInOutImage;

    public DataStageOutLabelProvider() {
        this.loadImages();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof DataStagingType) {
            DataStagingType dataStagingType = (DataStagingType)element;
            switch (columnIndex) {
                case 0: {
                    if (dataStagingType.getSource() != null && dataStagingType.getTarget() != null) {
                        image = this.stageInOutImage;
                        break;
                    }
                    if (dataStagingType.getTarget() == null) break;
                    image = this.stageOutImage;
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataStagingType dataStagingType;
        String text = null;
        if (element instanceof DataStagingType && (dataStagingType = (DataStagingType)element).getTarget() != null) {
            switch (columnIndex) {
                case 0: {
                    text = dataStagingType.getFileName();
                    break;
                }
                case 1: {
                    text = dataStagingType.getTarget().getURI();
                    break;
                }
                case 2: {
                    text = dataStagingType.getCreationFlag().getName();
                    break;
                }
                case 3: {
                    text = Boolean.toString(dataStagingType.isDeleteOnTermination());
                    break;
                }
            }
        }
        return text;
    }

    void loadImages() {
        URL stageOutURL = Activator.getDefault().getBundle().getEntry("icons/stage-out.gif");
        URL stageInOutURL = Activator.getDefault().getBundle().getEntry("icons/stage-in-out.gif");
        ImageDescriptor stageOutDesc = ImageDescriptor.createFromURL((URL)stageOutURL);
        ImageDescriptor stageInOutDesc = ImageDescriptor.createFromURL((URL)stageInOutURL);
        this.stageOutImage = stageOutDesc.createImage();
        this.stageInOutImage = stageInOutDesc.createImage();
    }
}

