/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.widgets;

import eu.geclipse.jsdl.JSDLModelFacade;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.ui.internal.dialogs.DataStagingOutDialog;
import eu.geclipse.jsdl.ui.widgets.Messages;
import eu.geclipse.ui.dialogs.GridFileDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStageOutTable {
    public static final int BUTTONS_RIGHT = 0;
    public static final int BUTTONS_BOTTOM = 1;
    Composite mainComp;
    TableViewer tableViewer;
    List<DataStagingType> input = new ArrayList<DataStagingType>();
    private Table table;
    private Button addButton;
    private Button editButton;
    private Button removeButton;

    public DataStageOutTable(Composite parent, int buttonsPosition) {
        this(parent, new ArrayList<DataStagingType>(), buttonsPosition);
    }

    public DataStageOutTable(Composite parent, List<DataStagingType> input, int buttonsPosition) {
        this.input = input;
        this.mainComp = new Composite(parent, 0);
        GridLayout gLayout = buttonsPosition == 1 ? new GridLayout(1, false) : new GridLayout(2, false);
        this.mainComp.setLayout((Layout)gLayout);
        GridData gData = new GridData(1808);
        this.mainComp.setLayoutData((Object)gData);
        this.table = new Table(this.mainComp, 268503042);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gData = new GridData(1808);
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.table.setLayoutData((Object)gData);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(this.table, 0x1000000);
        ColumnWeightData data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)data);
        nameColumn.setText(Messages.getString("DataStageInTable.name_field_label"));
        TableColumn locationColumn = new TableColumn(this.table, 16384);
        locationColumn.setText(Messages.getString("DataStageInTable.target_location_field_label"));
        this.tableViewer = new TableViewer(this.table);
        DataStageInContentProvider contentProvider = new DataStageInContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setColumnProperties(new String[]{Messages.getString("DataStageInTable.name_field_label"), Messages.getString("DataStageInTable.target_location_field_label")});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DataStageInContentLabelProvider());
        if (this.input == null) {
            this.input = new ArrayList<DataStagingType>();
        }
        this.tableViewer.setInput(this.input);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataStageOutTable.this.updateButtons();
            }
        });
        Composite buttonsComp = new Composite(this.mainComp, 0);
        gLayout = buttonsPosition == 1 ? new GridLayout(3, true) : new GridLayout(1, false);
        buttonsComp.setLayout((Layout)gLayout);
        this.addButton = new Button(buttonsComp, 8);
        gData = new GridData(130);
        buttonsComp.setLayoutData((Object)gData);
        gData = new GridData(1808);
        this.addButton.setLayoutData((Object)gData);
        this.addButton.setText(Messages.getString("DataStageInTable.add_button_label"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataStageOutTable.this.editDataStagingEntry(null);
            }
        });
        this.editButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.editButton.setLayoutData((Object)gData);
        this.editButton.setText(Messages.getString("DataStageInTable.edit_button_label"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataStageOutTable.this.editDataStagingEntry(DataStageOutTable.this.getSelectedObject());
            }
        });
        this.removeButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.removeButton.setLayoutData((Object)gData);
        this.removeButton.setText(Messages.getString("DataStageInTable.remove_button_label"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataStageOutTable.this.input.remove(DataStageOutTable.this.getSelectedObject());
                DataStageOutTable.this.tableViewer.refresh();
            }
        });
        DialogCellEditor editor = new DialogCellEditor(){

            protected Object openDialogBox(Control cellEditorWindow) {
                URI[] uris;
                String filename = (String)this.doGetValue();
                cellEditorWindow.getData();
                GridFileDialog dialog = new GridFileDialog(DataStageOutTable.this.mainComp.getShell(), 8);
                if (dialog.open() == 0 && (uris = dialog.getSelectedURIs()) != null && uris.length > 0) {
                    filename = uris[0].toString();
                }
                return filename;
            }
        };
        CellEditor[] table1 = new CellEditor[]{editor};
        editor.create((Composite)this.table);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                int columnIndex = -1;
                if (property.equals(Messages.getString("DataStageInTable.name_field_label"))) {
                    columnIndex = 0;
                }
                if (property.equals(Messages.getString("DataStageInTable.target_location_field_label"))) {
                    columnIndex = 1;
                }
                String result = null;
                DataStagingType data1 = (DataStagingType)element;
                switch (columnIndex) {
                    case 0: {
                        result = data1.getFileName();
                        break;
                    }
                    case 1: {
                        result = data1.getTarget().getURI();
                        break;
                    }
                    default: {
                        result = "";
                    }
                }
                return result;
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = -1;
                if (property.equals(Messages.getString("DataStageInTable.name_field_label"))) {
                    columnIndex = 0;
                }
                if (property.equals(Messages.getString("DataStageInTable.target_location_field_label"))) {
                    columnIndex = 1;
                }
                TableItem item = (TableItem)element;
                DataStagingType dataOld = (DataStagingType)item.getData();
                DataStagingType dataNew = null;
                switch (columnIndex) {
                    case 0: {
                        dataNew = DataStageOutTable.this.getNewDataStagingType((String)value, dataOld.getTarget().getURI());
                        if (dataNew.getFileName().equals(dataOld.getFileName()) && dataNew.getTarget().getURI().equals(dataOld.getTarget().getURI())) break;
                        if (!DataStageOutTable.this.isDataInInput(dataNew)) {
                            DataStageOutTable.this.input.add(dataNew);
                            DataStageOutTable.this.input.remove(dataOld);
                            DataStageOutTable.this.tableViewer.refresh();
                            break;
                        }
                        MessageDialog.openError((Shell)DataStageOutTable.this.mainComp.getShell(), (String)Messages.getString("DataStageOutTable.edit_dialog_title"), (String)Messages.getString("DataStageOutTable.data_exists_error"));
                        break;
                    }
                    case 1: {
                        dataNew = DataStageOutTable.this.getNewDataStagingType(dataOld.getFileName(), (String)value);
                        if (dataNew.getFileName().equals(dataOld.getFileName()) && dataNew.getTarget().getURI().equals(dataOld.getTarget().getURI())) break;
                        if (!DataStageOutTable.this.isDataInInput(dataNew)) {
                            DataStageOutTable.this.input.add(dataNew);
                            DataStageOutTable.this.input.remove(dataOld);
                            DataStageOutTable.this.tableViewer.refresh();
                            break;
                        }
                        MessageDialog.openError((Shell)DataStageOutTable.this.mainComp.getShell(), (String)Messages.getString("DataStageOutTable.edit_dialog_title"), (String)Messages.getString("DataStageOutTable.data_exists_error"));
                    }
                }
            }
        });
        CellEditor[] edTable = new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable()), editor};
        this.tableViewer.setCellEditors(edTable);
        TableViewerEditor.create((TableViewer)this.tableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer), (int)26);
        this.updateButtons();
    }

    DataStagingType getSelectedObject() {
        DataStagingType result = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof DataStagingType) {
            result = (DataStagingType)obj;
        }
        return result;
    }

    public List<DataStagingType> getDataStagingType() {
        return this.input;
    }

    public void setInput(List<DataStagingType> input) {
        this.input = input;
        if (this.input == null) {
            this.input = new ArrayList<DataStagingType>();
        }
        this.tableViewer.setInput(this.input);
    }

    void editDataStagingEntry(DataStagingType selectedObject) {
        if (selectedObject == null) {
            DataStagingOutDialog dialog = new DataStagingOutDialog(this.mainComp.getShell(), 0);
            if (dialog.open() == 0) {
                for (DataStagingType newData : this.getNewDataStagingType(dialog.getDataStageInList())) {
                    if (!this.isDataInInput(newData)) {
                        this.input.add(newData);
                        continue;
                    }
                    MessageDialog.openError((Shell)this.mainComp.getShell(), (String)Messages.getString("DataStageOutTable.new_dialog_title"), (String)Messages.getString("DataStageOutTable.data_exists_error"));
                }
                this.tableViewer.refresh();
            }
        } else {
            DataStagingOutDialog dialog = new DataStagingOutDialog(this.mainComp.getShell(), 0, selectedObject);
            if (dialog.open() == 0) {
                for (DataStagingType newData : this.getNewDataStagingType(dialog.getDataStageInList())) {
                    if (newData.getFileName().equals(selectedObject.getFileName()) && newData.getTarget().getURI().equals(selectedObject.getTarget().getURI())) continue;
                    if (!this.isDataInInput(newData)) {
                        this.input.add(newData);
                        this.input.remove(selectedObject);
                        this.tableViewer.refresh();
                        continue;
                    }
                    MessageDialog.openError((Shell)this.mainComp.getShell(), (String)Messages.getString("DataStageOutTable.edit_dialog_title"), (String)Messages.getString("DataStageOutTable.data_exists_error"));
                }
            }
        }
    }

    boolean isDataInInput(DataStagingType newData) {
        boolean result = false;
        for (DataStagingType data : this.input) {
            if (!data.getFileName().equals(newData.getFileName()) || !data.getTarget().getURI().equals(newData.getTarget().getURI())) continue;
            result = true;
        }
        return result;
    }

    List<DataStagingType> getNewDataStagingType(ArrayList<DataStagingType> dataStageList) {
        ArrayList<DataStagingType> result = new ArrayList<DataStagingType>();
        DataStagingType dsType = null;
        SourceTargetType target = null;
        int i = 0;
        while (i < dataStageList.size()) {
            dsType = JSDLModelFacade.getDataStagingType();
            target = JSDLModelFacade.getSourceTargetType();
            DataStagingType temp = dataStageList.get(i);
            dsType.setFileName(temp.getFileName());
            target.setURI(temp.getTarget().getURI());
            dsType.setTarget(target);
            dsType.setCreationFlag(JSDLModelFacade.getDefaultCreationFlag());
            dsType.setDeleteOnTermination(false);
            result.add(dsType);
            ++i;
        }
        return result;
    }

    DataStagingType getNewDataStagingType(String name, String path) {
        DataStagingType result = JSDLModelFacade.getDataStagingType();
        result.setFileName(name);
        SourceTargetType target = JSDLModelFacade.getSourceTargetType();
        target.setURI(path);
        result.setTarget(target);
        result.setCreationFlag(JSDLModelFacade.getDefaultCreationFlag());
        result.setDeleteOnTermination(false);
        return result;
    }

    protected void updateButtons() {
        ISelection selection = this.tableViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(selectionAvailable);
        this.editButton.setEnabled(selectionAvailable);
    }

    public void updateInput(List<DataStagingType> newInput) {
        this.input = newInput;
        this.tableViewer.setInput(this.input);
    }

    class DataStageInContentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DataStageInContentLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                DataStagingType var = (DataStagingType)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getFileName();
                        break;
                    }
                    case 1: {
                        result = var.getTarget().getURI();
                    }
                }
            }
            return result;
        }
    }

    class DataStageInContentProvider
    implements IStructuredContentProvider {
        DataStageInContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new DataStagingType[]{};
            elements = ((List)inputElement).toArray(new DataStagingType[0]);
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

