/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.widgets;

import eu.geclipse.jsdl.ui.adapters.jsdl.ParametricJobAdapter;
import eu.geclipse.jsdl.ui.widgets.Messages;
import eu.geclipse.jsdl.ui.widgets.SweepLoopDialog;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersDialog
extends Dialog
implements ModifyListener {
    public static final String WITH_REF = "ref";
    public static final String NEW_ELEMENT = "new";
    private static final String SEPARATOR_PROPERTY = "line.separator";
    Text valuesText;
    private Combo refElement;
    private Combo element;
    private List<String> parameters;
    private String refElementInit;
    private String mode;
    private String refElementReturn;
    private String elementReturn;
    private List<String> refElements;
    private List<String> values;

    public ParametersDialog(Shell parentShell, List<String> parameters, List<String> refElements, String refElement, String mode) {
        super(parentShell);
        this.parameters = parameters;
        this.refElementInit = refElement;
        this.refElements = refElements;
        this.mode = mode;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData();
        Label elemLabel = new Label(mainComp, 16384);
        elemLabel.setText(Messages.getString("ParametersDialog.sweeped_element_label"));
        elemLabel.setLayoutData((Object)gData);
        this.element = new Combo(mainComp, 12);
        this.element.setVisibleItemCount(16);
        gData = new GridData(768);
        this.element.setLayoutData((Object)gData);
        for (String val : this.parameters) {
            this.element.add(val);
        }
        this.element.addModifyListener((ModifyListener)this);
        if (this.mode.equals(WITH_REF)) {
            Label refLabel = new Label(mainComp, 16384);
            refLabel.setText(Messages.getString("ParametersDialog.referenced_element_label"));
            gData = new GridData();
            refLabel.setLayoutData((Object)gData);
            this.refElement = new Combo(mainComp, 12);
            this.refElement.setVisibleItemCount(16);
            int selIndex = -1;
            for (String val : this.refElements) {
                this.refElement.add(val);
            }
            if (this.refElementInit != null) {
                int i = -1;
                String[] stringArray = this.refElement.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String comboElem = stringArray[n2];
                    ++i;
                    if (comboElem.equals(this.refElementInit)) {
                        selIndex = i;
                    }
                    ++n2;
                }
            }
            if (selIndex != -1) {
                this.refElement.select(selIndex);
            }
            gData = new GridData(768);
            gData.widthHint = 500;
            this.refElement.setLayoutData((Object)gData);
            this.refElement.addModifyListener((ModifyListener)this);
        }
        Label valuesLabel = new Label(mainComp, 16384);
        valuesLabel.setText(Messages.getString("ParametersDialog.values_label"));
        gData = new GridData();
        valuesLabel.setLayoutData((Object)gData);
        this.valuesText = new Text(mainComp, 2562);
        gData = new GridData(1808);
        gData.heightHint = 30;
        gData.verticalSpan = 15;
        this.valuesText.setLayoutData((Object)gData);
        this.valuesText.setToolTipText(Messages.getString("ParametersDialog.values_new_line_separation_info_tooltip"));
        Label valuesHint = new Label(mainComp, 16384);
        valuesHint.setText(Messages.getString("ParametersDialog.values_new_line_separation_info"));
        gData = new GridData();
        valuesHint.setLayoutData((Object)gData);
        Button loopButton = new Button(mainComp, 8);
        loopButton.setText(Messages.getString("ParametersDialog.loop_button"));
        gData = new GridData();
        gData.verticalIndent = 10;
        gData.horizontalAlignment = 0x1000000;
        gData.verticalAlignment = 0x1000000;
        loopButton.setLayoutData((Object)gData);
        loopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepLoopDialog dialog = new SweepLoopDialog(parent.getShell());
                if (dialog.open() == 0) {
                    ArrayList<BigInteger> exceptions = new ArrayList<BigInteger>();
                    String[] stringArray = dialog.getExceptionsReturn();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String exc = stringArray[n2];
                        exceptions.add(new BigInteger(exc));
                        ++n2;
                    }
                    String loop = ParametricJobAdapter.createLOOPString(new BigInteger(dialog.getStartReturn()), new BigInteger(dialog.getEndReturn()), new BigInteger(dialog.getStepReturn()), exceptions);
                    ParametersDialog.this.valuesText.setText(loop);
                }
            }
        });
        return mainComp;
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.updateButtons();
        return result;
    }

    private void updateButtons() {
        if (this.mode.equals(NEW_ELEMENT)) {
            super.getButton(0).setEnabled(!this.element.getText().equals(""));
        } else if (!this.element.getText().equals("") && !this.refElement.getText().equals("")) {
            super.getButton(0).setEnabled(true);
        } else {
            super.getButton(0).setEnabled(false);
        }
    }

    public void modifyText(ModifyEvent event) {
        this.updateButtons();
    }

    protected void okPressed() {
        this.elementReturn = this.element.getText();
        if (this.mode.equals(WITH_REF)) {
            this.refElementReturn = this.refElement.getText();
            if (this.refElementReturn.equals(this.elementReturn)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ParametersDialog.error_title"), (String)Messages.getString("ParametersDialog.element_referenig_to_itself_error"));
            }
        }
        this.values = new ArrayList<String>();
        if (!this.valuesText.getText().equals("")) {
            String wholeValues = this.valuesText.getText();
            String[] stringArray = wholeValues.split(System.getProperty(SEPARATOR_PROPERTY));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.values.add(value);
                ++n2;
            }
        }
        super.okPressed();
    }

    public String getRefElementReturn() {
        return this.refElementReturn;
    }

    public String getElementReturn() {
        return this.elementReturn;
    }

    public List<String> getValuesReturn() {
        return this.values;
    }
}

